/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.common.RqueueLockManager;
import com.github.sonus21.rqueue.converter.GenericMessageConverter;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageManager;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.BaseMessageSender;
import com.github.sonus21.rqueue.exception.LockCanNotBeAcquired;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageHeaders;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.utils.MessageUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class RqueueMessageManagerImpl
extends BaseMessageSender
implements RqueueMessageManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageManagerImpl.class);
    @Autowired
    private RqueueLockManager rqueueLockManager;

    private RqueueMessageManagerImpl(RqueueMessageTemplate messageTemplate, List<MessageConverter> messageConverters, boolean addDefault) {
        super(messageTemplate);
        Assert.notEmpty(messageConverters, (String)"messageConverters cannot be empty");
        this.init(messageConverters, addDefault);
    }

    public RqueueMessageManagerImpl(RqueueMessageTemplate messageTemplate) {
        this(messageTemplate, Collections.singletonList(new GenericMessageConverter()), false);
    }

    public RqueueMessageManagerImpl(RqueueMessageTemplate messageTemplate, List<MessageConverter> messageConverters) {
        this(messageTemplate, messageConverters, false);
    }

    @Override
    public boolean deleteAllMessages(String queueName) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        try {
            this.stringRqueueRedisTemplate.delete(queueDetail.getQueueName());
            this.stringRqueueRedisTemplate.delete(queueDetail.getProcessingQueueName());
            this.stringRqueueRedisTemplate.delete(queueDetail.getDelayedQueueName());
            return true;
        }
        catch (Exception e) {
            log.error("Delete all message failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public List<Object> getAllMessages(String queueName) {
        ArrayList<Object> messages = new ArrayList<Object>();
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        for (RqueueMessage message : this.messageTemplate.getAllMessages(queueDetail.getQueueName(), queueDetail.getProcessingQueueName(), queueDetail.getDelayedQueueName())) {
            messages.add(MessageUtils.convertMessageToObject(message, (MessageConverter)this.messageConverter));
        }
        return messages;
    }

    @Override
    public Object getMessage(String queueName, String id) {
        RqueueMessage rqueueMessage = this.getRqueueMessage(queueName, id);
        if (rqueueMessage == null) {
            return null;
        }
        Message message = MessageBuilder.createMessage((Object)rqueueMessage.getMessage(), (MessageHeaders)RqueueMessageHeaders.emptyMessageHeaders());
        return this.messageConverter.fromMessage(message, null);
    }

    @Override
    public RqueueMessage getRqueueMessage(String queueName, String id) {
        MessageMetadata messageMetadata = this.rqueueMessageMetadataService.getByMessageId(queueName, id);
        if (messageMetadata == null) {
            return null;
        }
        return messageMetadata.getRqueueMessage();
    }

    @Override
    public boolean exist(String queueName, String id) {
        if (this.rqueueLockManager.acquireLock(queueName, Duration.ofSeconds(1L))) {
            boolean exist = this.getMessage(queueName, id) != null;
            this.rqueueLockManager.releaseLock(queueName);
            return exist;
        }
        throw new LockCanNotBeAcquired(queueName);
    }

    @Override
    public boolean deleteMessage(String queueName, String id) {
        RqueueMessage rqueueMessage = this.getRqueueMessage(queueName, id);
        if (rqueueMessage == null) {
            return false;
        }
        this.rqueueMessageMetadataService.deleteMessage(queueName, id, Duration.ofMinutes(this.rqueueConfig.getMessageDurabilityInMinute()));
        return true;
    }

    @Override
    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }
}

