/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.utils.BaseLogger;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.event.Level;

abstract class MessageContainerBase
extends BaseLogger
implements Runnable {
    protected final WeakReference<RqueueMessageListenerContainer> container;

    MessageContainerBase(Logger log, String groupName, RqueueMessageListenerContainer container) {
        this(log, groupName, new WeakReference<RqueueMessageListenerContainer>(container));
    }

    MessageContainerBase(Logger log, String groupName, WeakReference<RqueueMessageListenerContainer> container) {
        super(log, groupName);
        this.container = container;
    }

    protected RqueueMessageTemplate getRqueueMessageTemplate() {
        return ((RqueueMessageListenerContainer)Objects.requireNonNull(this.container.get())).getRqueueMessageTemplate();
    }

    boolean isQueueActive(String queueName) {
        return ((RqueueMessageListenerContainer)Objects.requireNonNull(this.container.get())).isQueueActive(queueName);
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (Exception e) {
            this.log(Level.ERROR, "Failed {}", e, e.getMessage());
        }
    }

    abstract void start();
}

