/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.annotation.RqueueListener;
import com.github.sonus21.rqueue.converter.GenericMessageConverter;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.exception.QueueDoesNotExist;
import com.github.sonus21.rqueue.listener.MappingInformation;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.Concurrency;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.ValueResolver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.annotation.support.AnnotationExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadArgumentResolver;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.invocation.AbstractMethodMessageHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.comparator.ComparableComparator;

public class RqueueMessageHandler
extends AbstractMethodMessageHandler<MappingInformation> {
    private ConversionService conversionService = new DefaultFormattingConversionService();
    private final MessageConverter messageConverter;

    public RqueueMessageHandler() {
        this(Collections.emptyList());
    }

    public RqueueMessageHandler(List<MessageConverter> messageConverters) {
        Assert.notNull(messageConverters, (String)"messageConverters cannot be null");
        ArrayList<MessageConverter> messageConverterList = new ArrayList<MessageConverter>(messageConverters);
        messageConverterList.add(new GenericMessageConverter());
        this.messageConverter = new CompositeMessageConverter(messageConverterList);
    }

    private ConfigurableBeanFactory getBeanFactory() {
        ApplicationContext context = this.getApplicationContext();
        return context instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)context).getBeanFactory() : null;
    }

    protected List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        ArrayList<Object> resolvers = new ArrayList<Object>(this.getCustomArgumentResolvers());
        resolvers.add(new HeaderMethodArgumentResolver(this.conversionService, this.getBeanFactory()));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new PrincipalMethodArgumentResolver());
        resolvers.add(new MessageMethodArgumentResolver(this.messageConverter));
        resolvers.add(new PayloadArgumentResolver(this.messageConverter, null));
        return resolvers;
    }

    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        return new ArrayList(this.getCustomReturnValueHandlers());
    }

    protected boolean isHandler(Class<?> beanType) {
        return true;
    }

    private Concurrency resolveConcurrency(RqueueListener rqueueListener) {
        int upperLimit;
        String val = ValueResolver.resolveKeyToString(this.getApplicationContext(), rqueueListener.concurrency());
        if (val.equals("-1")) {
            return new Concurrency(-1, -1);
        }
        String[] vals = val.split("-");
        if (vals.length > 2 || vals.length == 0) {
            throw new IllegalStateException("Concurrency must be either some number e.g. 5 or in the form of 5-10");
        }
        if (vals.length == 1) {
            int concurrency = this.parseInt(vals[0], "Concurrency is not a number", "Concurrency is not a number");
            return new Concurrency(1, concurrency);
        }
        int lowerLimit = this.parseInt(vals[0], "Concurrency lower limit is not a number", "Concurrency lower limit must be non-zero");
        if (lowerLimit > (upperLimit = this.parseInt(vals[1], "Concurrency upper limit is not a number", "Concurrency upper limit must be non-zero"))) {
            throw new IllegalStateException("upper limit of concurrency is smaller than the lower limit");
        }
        return new Concurrency(lowerLimit, upperLimit);
    }

    private String resolvePriorityGroup(RqueueListener rqueueListener) {
        return ValueResolver.resolveKeyToString(this.getApplicationContext(), rqueueListener.priorityGroup());
    }

    private int parseInt(String txt, String message, String nonZeroText) {
        try {
            int n = Integer.parseInt(txt);
            if (n <= 0) {
                throw new IllegalStateException(nonZeroText);
            }
            return n;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(message, e);
        }
    }

    private Map<String, Integer> resolvePriority(RqueueListener rqueueListener) {
        String[] priorities = ValueResolver.resolveKeyToArrayOfStrings(this.getApplicationContext(), rqueueListener.priority());
        HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        if (priorities.length == 0 || priorities[0].equals("")) {
            return priorityMap;
        }
        for (String priority : priorities) {
            String[] vals = priority.split(":");
            if (vals.length == 1) {
                vals = priority.split("=");
            }
            if (vals.length == 1) {
                if (!priorityMap.isEmpty()) {
                    throw new IllegalStateException("Invalid priority configuration is used.");
                }
                priorityMap.put("DEFAULT_PRIORITY", this.parseInt(vals[0], "priority is not a number.", "priority must be greater than or equal to 1"));
                continue;
            }
            if (vals.length == 2) {
                priorityMap.put(vals[0], this.parseInt(vals[1], "priority is not a number.", "priority must be greater than or equal to 1"));
                continue;
            }
            throw new IllegalStateException("Priority cannot be parsed");
        }
        return Collections.unmodifiableMap(priorityMap);
    }

    protected MappingInformation getMappingForMethod(Method method, Class<?> handlerType) {
        RqueueListener rqueueListener = (RqueueListener)AnnotationUtils.findAnnotation((Method)method, RqueueListener.class);
        if (rqueueListener != null) {
            Set<String> queueNames = this.resolveQueueNames(rqueueListener);
            String deadLetterQueueName = this.resolveDeadLetterQueue(rqueueListener);
            int numRetries = this.resolveNumRetries(rqueueListener);
            long visibilityTimeout = this.resolveVisibilityTimeout(rqueueListener);
            boolean active = this.isActive(rqueueListener);
            boolean consumerEnabled = this.resolveConsumerEnabled(rqueueListener);
            Concurrency concurrency = this.resolveConcurrency(rqueueListener);
            Map<String, Integer> priorityMap = this.resolvePriority(rqueueListener);
            String priorityGroup = this.resolvePriorityGroup(rqueueListener);
            MappingInformation mappingInformation = MappingInformation.builder().active(active).concurrency(concurrency).deadLetterQueueName(deadLetterQueueName).deadLetterConsumerEnabled(consumerEnabled).numRetry(numRetries).queueNames(queueNames).visibilityTimeout(visibilityTimeout).priorityGroup(priorityGroup).priority(priorityMap).build();
            if (mappingInformation.isValid()) {
                return mappingInformation;
            }
            this.logger.warn((Object)("Queue '" + mappingInformation + "' not configured"));
        }
        return null;
    }

    private boolean resolveConsumerEnabled(RqueueListener rqueueListener) {
        return ValueResolver.resolveToBoolean(this.getApplicationContext(), rqueueListener.deadLetterQueueListenerEnabled());
    }

    private long resolveVisibilityTimeout(RqueueListener rqueueListener) {
        return ValueResolver.resolveKeyToLong(this.getApplicationContext(), rqueueListener.visibilityTimeout());
    }

    private int resolveNumRetries(RqueueListener rqueueListener) {
        return ValueResolver.resolveKeyToInteger(this.getApplicationContext(), rqueueListener.numRetries());
    }

    private String resolveDeadLetterQueue(RqueueListener rqueueListener) {
        String dlqName = rqueueListener.deadLetterQueue();
        String[] resolvedValues = ValueResolver.resolveKeyToArrayOfStrings(this.getApplicationContext(), dlqName);
        if (resolvedValues.length == 1) {
            return resolvedValues[0];
        }
        throw new IllegalStateException("more than one dead letter queue cannot be configured '" + dlqName + "'");
    }

    private boolean isActive(RqueueListener rqueueListener) {
        return ValueResolver.resolveToBoolean(this.getApplicationContext(), rqueueListener.active());
    }

    private Set<String> resolveQueueNames(RqueueListener rqueueListener) {
        String[] queueNames = rqueueListener.value();
        HashSet<String> result = new HashSet<String>(queueNames.length);
        for (String queueName : queueNames) {
            result.addAll(Arrays.asList(ValueResolver.resolveKeyToArrayOfStrings(this.getApplicationContext(), queueName)));
        }
        return Collections.unmodifiableSet(result);
    }

    protected Set<String> getDirectLookupDestinations(MappingInformation mapping) {
        HashSet<String> destinations = new HashSet<String>(mapping.getQueueNames());
        for (String queueName : mapping.getQueueNames()) {
            destinations.addAll(PriorityUtils.getNamesFromPriority(queueName, mapping.getPriority()));
        }
        return destinations;
    }

    protected String getDestination(Message<?> message) {
        return (String)message.getHeaders().get((Object)"destination");
    }

    protected MappingInformation getMatchingMapping(MappingInformation mapping, Message<?> message) {
        String destination = this.getDestination(message);
        if (mapping.getQueueNames().contains(destination)) {
            return mapping;
        }
        try {
            QueueDetail queueDetail = EndpointRegistry.get(destination);
            if (queueDetail.isSystemGenerated()) {
                queueDetail = EndpointRegistry.get(queueDetail.getPriorityGroup());
                if (mapping.getQueueNames().contains(queueDetail.getName())) {
                    return mapping;
                }
            }
        }
        catch (QueueDoesNotExist e) {
            return null;
        }
        return null;
    }

    protected Comparator<MappingInformation> getMappingComparator(Message<?> message) {
        return new ComparableComparator();
    }

    protected AbstractExceptionHandlerMethodResolver createExceptionHandlerMethodResolverFor(Class<?> beanType) {
        return new AnnotationExceptionHandlerMethodResolver(beanType);
    }

    protected void processHandlerMethodException(HandlerMethod handlerMethod, Exception ex, Message<?> message) {
        super.processHandlerMethodException(handlerMethod, ex, message);
        throw new MessagingException("An exception occurred while invoking the handler method", (Throwable)ex);
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }
}

