/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.listener.MessageContainerBase;
import com.github.sonus21.rqueue.listener.PostProcessingHandler;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.listener.RqueueExecutor;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.utils.ThreadUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

abstract class RqueueMessagePoller
extends MessageContainerBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessagePoller.class);
    private final PostProcessingHandler postProcessingHandler;
    private final RqueueConfig rqueueConfig;
    List<String> queues;

    RqueueMessagePoller(String groupName, RqueueMessageListenerContainer container, PostProcessingHandler postProcessingHandler, RqueueConfig rqueueConfig) {
        super(log, groupName, container);
        this.postProcessingHandler = postProcessingHandler;
        this.rqueueConfig = rqueueConfig;
    }

    private RqueueMessage getMessage(QueueDetail queueDetail) {
        return this.getRqueueMessageTemplate().pop(queueDetail.getQueueName(), queueDetail.getProcessingQueueName(), queueDetail.getProcessingQueueChannelName(), queueDetail.getVisibilityTimeout());
    }

    long getPollingInterval() {
        return ((RqueueMessageListenerContainer)Objects.requireNonNull(this.container.get())).getPollingInterval();
    }

    long getBackOffTime() {
        return ((RqueueMessageListenerContainer)Objects.requireNonNull(this.container.get())).getBackOffTime();
    }

    private void execute(ThreadUtils.QueueThread queueThread, QueueDetail queueDetail, RqueueMessage message) {
        queueThread.getTaskExecutor().execute((Runnable)new RqueueExecutor(message, queueDetail, queueThread.getSemaphore(), this.container, this.rqueueConfig, this.postProcessingHandler));
    }

    boolean shouldExit() {
        for (String queueName : this.queues) {
            if (!this.isQueueActive(queueName)) continue;
            return false;
        }
        this.log(Level.INFO, "Shutting down all queues are inactive {}", null, this.queues);
        return true;
    }

    void poll(int index, String queue, QueueDetail queueDetail, ThreadUtils.QueueThread queueThread) {
        boolean acquired;
        this.log(Level.DEBUG, "Polling queue {}", null, queue);
        Semaphore semaphore = queueThread.getSemaphore();
        try {
            acquired = semaphore.tryAcquire(this.getSemaphoreWaiTime(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.log(Level.WARN, "Exception {}", e, e.getMessage());
            this.deactivate(index, queue, DeactivateType.SEMAPHORE_EXCEPTION);
            return;
        }
        if (!acquired) {
            this.deactivate(index, queue, DeactivateType.SEMAPHORE_UNAVAILABLE);
        } else if (this.isQueueActive(queue)) {
            try {
                RqueueMessage message = this.getMessage(queueDetail);
                this.log(Level.DEBUG, "Queue: {} Fetched Msg {}", null, queue, message);
                if (message != null) {
                    this.execute(queueThread, queueDetail, message);
                } else {
                    semaphore.release();
                    this.deactivate(index, queue, DeactivateType.NO_MESSAGE);
                }
            }
            catch (Exception e) {
                semaphore.release();
                this.log(Level.WARN, "Listener failed for the queue {}", e, queue);
                this.deactivate(index, queue, DeactivateType.POLL_FAILED);
            }
        }
    }

    abstract long getSemaphoreWaiTime();

    abstract void deactivate(int var1, String var2, DeactivateType var3);

    static enum DeactivateType {
        POLL_FAILED,
        NO_MESSAGE,
        SEMAPHORE_EXCEPTION,
        SEMAPHORE_UNAVAILABLE;

    }
}

