/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.listener.PostProcessingHandler;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.listener.RqueueMessagePoller;
import com.github.sonus21.rqueue.utils.ThreadUtils;
import com.github.sonus21.rqueue.utils.TimeoutUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.event.Level;

class WeightedPriorityPoller
extends RqueueMessagePoller {
    private final Map<String, ThreadUtils.QueueThread> queueNameToThread;
    private final Map<String, QueueDetail> queueNameToDetail;
    private List<QueueDetail> queueDetailList;
    private int[] currentWeight;
    private int[] weight;
    private float[] probability;
    private int currentIndex = 0;

    WeightedPriorityPoller(String groupName, RqueueMessageListenerContainer container, List<QueueDetail> queueDetails, Map<String, ThreadUtils.QueueThread> queueNameToThread, PostProcessingHandler postProcessingHandler, RqueueConfig rqueueConfig) {
        super("Weighted-" + groupName, container, postProcessingHandler, rqueueConfig);
        this.queueDetailList = queueDetails;
        this.queues = queueDetails.stream().map(QueueDetail::getName).collect(Collectors.toList());
        this.queueNameToDetail = queueDetails.stream().collect(Collectors.toMap(QueueDetail::getName, Function.identity()));
        this.queueNameToThread = queueNameToThread;
    }

    private void initializeWeight() {
        int i;
        this.currentWeight = new int[this.queues.size()];
        this.weight = new int[this.queues.size()];
        this.probability = new float[this.queues.size()];
        float total = 0.0f;
        for (i = 0; i < this.queues.size(); ++i) {
            QueueDetail queueDetail = this.queueDetailList.get(i);
            this.currentWeight[i] = queueDetail.getPriority().get("DEFAULT_PRIORITY");
            this.weight[i] = this.currentWeight[i];
            total += (float)this.weight[i];
        }
        if (total == 0.0f) {
            throw new IllegalStateException("Total priority is zero!!");
        }
        for (i = 0; i < this.weight.length; ++i) {
            this.probability[i] = (float)this.weight[i] / total;
        }
    }

    private void reinitializeWeight() {
        this.currentIndex = 0;
        System.arraycopy(this.weight, 0, this.currentWeight, 0, this.weight.length);
        this.log(Level.DEBUG, "reinitialized weight {}", null, new Object[]{this.currentWeight});
    }

    private int getQueueIndexToPoll() {
        int tmpIndex = (this.currentIndex + 1) % this.queues.size();
        while (tmpIndex != this.currentIndex) {
            String queue = (String)this.queues.get(tmpIndex);
            if (this.currentWeight[tmpIndex] > 0 && this.isQueueActive(queue)) {
                int n = tmpIndex;
                this.currentWeight[n] = this.currentWeight[n] - 1;
                this.currentIndex = tmpIndex;
                return this.currentIndex;
            }
            tmpIndex = (tmpIndex + 1) % this.queues.size();
        }
        return -1;
    }

    private int getQueueToPollOrWait() {
        int index = this.getQueueIndexToPoll();
        if (index == -1) {
            if (this.shouldExit()) {
                return -1;
            }
            index = -2;
        }
        if (this.isDebugEnabled()) {
            if (index >= 0) {
                this.log(Level.DEBUG, "Polling queue: {}", null, this.queues.get(index));
            } else {
                this.log(Level.DEBUG, "No queue to poll", null, new Object[0]);
            }
        }
        return index;
    }

    private void printDebugDetail() {
        if (!this.isDebugEnabled()) {
            return;
        }
        List weightStr = Arrays.stream(this.currentWeight).mapToObj(String::valueOf).collect(Collectors.toList());
        this.log(Level.DEBUG, "Running Queues: {} Weight: {} Average: {}", null, this.queues, weightStr, this.probability);
    }

    @Override
    void start() {
        this.initializeWeight();
        this.printDebugDetail();
        while (true) {
            try {
                while (true) {
                    int index;
                    if ((index = this.getQueueToPollOrWait()) == -1) {
                        return;
                    }
                    if (index == -2) {
                        TimeoutUtils.sleepLog(this.getPollingInterval(), false);
                        this.reinitializeWeight();
                        continue;
                    }
                    String queue = (String)this.queues.get(index);
                    ThreadUtils.QueueThread queueThread = this.queueNameToThread.get(queue);
                    QueueDetail queueDetail = this.queueNameToDetail.get(queue);
                    this.poll(index, queue, queueDetail, queueThread);
                }
            }
            catch (Exception e) {
                this.log(Level.ERROR, "Error in poller", e, new Object[0]);
                if (!this.shouldExit()) continue;
                return;
            }
            break;
        }
    }

    @Override
    long getSemaphoreWaiTime() {
        return 25L;
    }

    @Override
    void deactivate(int index, String queue, RqueueMessagePoller.DeactivateType deactivateType) {
        if (deactivateType == RqueueMessagePoller.DeactivateType.POLL_FAILED) {
            TimeoutUtils.sleepLog(this.getBackOffTime(), false);
        } else {
            int n = index;
            this.currentWeight[n] = (int)((float)this.currentWeight[n] - (float)this.currentWeight[index] * (1.0f - this.probability[index]));
        }
    }
}

