/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.db;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.models.SerializableBase;
import com.github.sonus21.rqueue.models.db.MessageStatus;
import com.github.sonus21.rqueue.utils.MessageUtils;
import lombok.Generated;

public class MessageMetadata
extends SerializableBase {
    private static final long serialVersionUID = 4200184682879443328L;
    private String id;
    private long totalExecutionTime;
    private boolean deleted;
    private Long deletedOn;
    private RqueueMessage rqueueMessage;
    private MessageStatus status;

    public MessageMetadata(String id, MessageStatus messageStatus) {
        this.id = id;
        this.status = messageStatus;
    }

    public MessageMetadata(RqueueMessage rqueueMessage, MessageStatus messageStatus) {
        this.id = MessageUtils.getMessageMetaId(rqueueMessage.getQueueName(), rqueueMessage.getId());
        this.rqueueMessage = rqueueMessage;
        this.status = messageStatus;
    }

    public void addExecutionTime(long jobStartTime) {
        this.totalExecutionTime += System.currentTimeMillis() - jobStartTime;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public Long getDeletedOn() {
        return this.deletedOn;
    }

    @Generated
    public RqueueMessage getRqueueMessage() {
        return this.rqueueMessage;
    }

    @Generated
    public MessageStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTotalExecutionTime(long totalExecutionTime) {
        this.totalExecutionTime = totalExecutionTime;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDeletedOn(Long deletedOn) {
        this.deletedOn = deletedOn;
    }

    @Generated
    public void setRqueueMessage(RqueueMessage rqueueMessage) {
        this.rqueueMessage = rqueueMessage;
    }

    @Generated
    public void setStatus(MessageStatus status) {
        this.status = status;
    }

    @Generated
    public MessageMetadata(String id, long totalExecutionTime, boolean deleted, Long deletedOn, RqueueMessage rqueueMessage, MessageStatus status) {
        this.id = id;
        this.totalExecutionTime = totalExecutionTime;
        this.deleted = deleted;
        this.deletedOn = deletedOn;
        this.rqueueMessage = rqueueMessage;
        this.status = status;
    }

    @Generated
    public MessageMetadata() {
    }

    @Generated
    public String toString() {
        return "MessageMetadata(id=" + this.getId() + ", totalExecutionTime=" + this.getTotalExecutionTime() + ", deleted=" + this.isDeleted() + ", deletedOn=" + this.getDeletedOn() + ", rqueueMessage=" + this.getRqueueMessage() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }
}

