/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public enum TaskStatus {
    IGNORED("Ignored task", false),
    DELETED("Message deleted", false),
    SUCCESSFUL("Successful execution", true),
    DISCARDED("Message discarded", true),
    MOVED_TO_DLQ("Moved to dead letter queue messages", true),
    RETRIED("Retired at least once", true);

    private final String description;
    private final boolean chartEnabled;

    public static List<TaskStatus> getActiveChartStatus() {
        return Arrays.stream(TaskStatus.values()).filter(TaskStatus::isChartEnabled).collect(Collectors.toList());
    }

    @Generated
    private TaskStatus(String description, boolean chartEnabled) {
        this.description = description;
        this.chartEnabled = chartEnabled;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isChartEnabled() {
        return this.chartEnabled;
    }
}

