/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.utils.StringUtils;
import java.net.InetSocketAddress;
import java.net.Proxy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class HttpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    private static SimpleClientHttpRequestFactory getRequestFactory(RqueueConfig rqueueConfig) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setReadTimeout(2000);
        requestFactory.setConnectTimeout(2000);
        if (StringUtils.isEmpty(rqueueConfig.getProxyHost())) {
            return requestFactory;
        }
        Proxy proxy = new Proxy(rqueueConfig.getProxyType(), new InetSocketAddress(rqueueConfig.getProxyHost(), (int)rqueueConfig.getProxyPort()));
        requestFactory.setProxy(proxy);
        return requestFactory;
    }

    public static <T> T readUrl(RqueueConfig rqueueConfig, String url, Class<T> clazz) {
        try {
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)HttpUtils.getRequestFactory(rqueueConfig));
            return (T)restTemplate.getForObject(url, clazz, new Object[0]);
        }
        catch (Exception e) {
            log.error("GET call failed for {}", (Object)url, (Object)e);
            return null;
        }
    }
}

