/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.core.RqueueMessage;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;

public final class MessageUtils {
    private static final String META_DATA_KEY_PREFIX = "__rq::m-mdata::";
    private static final String KEY_SEPARATOR = "::";

    private MessageUtils() {
    }

    public static Object convertMessageToObject(RqueueMessage message, MessageConverter messageConverter) {
        return MessageUtils.convertMessageToObject((Message<String>)new GenericMessage((Object)message.getMessage()), messageConverter);
    }

    public static RqueueMessage buildMessage(MessageConverter messageConverter, String queueName, Object message, Integer retryCount, Long delayInMilliSecs) {
        Message msg = messageConverter.toMessage(message, null);
        if (msg == null) {
            throw new MessageConversionException("Message could not be build (null)");
        }
        return new RqueueMessage(queueName, (String)msg.getPayload(), retryCount, delayInMilliSecs);
    }

    public static Object convertMessageToObject(Message<String> message, MessageConverter messageConverter) {
        return messageConverter.fromMessage(message, null);
    }

    public static Object convertMessageToObject(Message<String> message, List<MessageConverter> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"messageConverters cannot be empty");
        for (MessageConverter messageConverter : messageConverters) {
            try {
                return messageConverter.fromMessage(message, null);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static String getMessageMetaId(String queueName, String messageId) {
        return META_DATA_KEY_PREFIX + queueName + KEY_SEPARATOR + messageId;
    }
}

