/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils.backoff;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.utils.backoff.TaskExecutionBackOff;

public class ExponentialTaskExecutionBackOff
implements TaskExecutionBackOff {
    public static final long DEFAULT_INITIAL_INTERVAL = 1500L;
    public static final double DEFAULT_MULTIPLIER = 1.5;
    public static final long DEFAULT_MAX_INTERVAL = 10800000L;
    private long initialInterval = 1500L;
    private long maxInterval = 10800000L;
    private double multiplier = 1.5;
    private int maxRetries = Integer.MAX_VALUE;

    public ExponentialTaskExecutionBackOff() {
    }

    public ExponentialTaskExecutionBackOff(long initialInterval, long maxInterval, double multiplier, int maxRetries) {
        this.checkInitialInterval(initialInterval);
        this.checkMaxInterval(initialInterval, maxInterval);
        this.checkMultiplier(multiplier);
        this.checkMaxRetries(maxRetries);
        this.initialInterval = initialInterval;
        this.maxInterval = maxInterval;
        this.multiplier = multiplier;
        this.maxRetries = maxRetries;
    }

    private void checkInitialInterval(long initialInterval) {
        if (initialInterval <= 0L) {
            throw new IllegalArgumentException("initialInterval must be > 0");
        }
    }

    private void checkMaxRetries(int maxRetries) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries must be > 0");
        }
    }

    private void checkMaxInterval(long initialInterval, long maxInterval) {
        if (maxInterval < initialInterval) {
            throw new IllegalArgumentException("maxInterval must be greater than or equal to initialInterval");
        }
    }

    private void checkMultiplier(double multiplier) {
        if (multiplier < 1.0) {
            throw new IllegalArgumentException("Invalid multiplier '" + multiplier + "'. Should be greater than or equal to 1. A multiplier of 1 is equivalent to a fixed interval.");
        }
    }

    public long getInitialInterval() {
        return this.initialInterval;
    }

    public void setInitialInterval(long initialInterval) {
        this.checkInitialInterval(initialInterval);
        this.initialInterval = initialInterval;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.checkMaxRetries(maxRetries);
        this.maxRetries = maxRetries;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.checkMultiplier(multiplier);
        this.multiplier = multiplier;
    }

    public long getMaxInterval() {
        return this.maxInterval;
    }

    public void setMaxInterval(long maxInterval) {
        this.checkMaxInterval(this.initialInterval, maxInterval);
        this.maxInterval = maxInterval;
    }

    @Override
    public long nextBackOff(Object object, RqueueMessage rqueueMessage, int failureCount) {
        if (failureCount >= this.getMaxRetries()) {
            return -1L;
        }
        return this.getDelay(failureCount);
    }

    protected long getDelay(int failureCount) {
        long maxDelay = (long)(Math.pow(this.getMultiplier(), failureCount) * (double)this.getInitialInterval());
        if (maxDelay == Long.MAX_VALUE) {
            return -1L;
        }
        return Math.min(maxDelay, this.getMaxInterval());
    }
}

