/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.models.db.MessageStatus;
import com.github.sonus21.rqueue.utils.MessageUtils;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class RqueueMessageMetadataServiceImpl
implements RqueueMessageMetadataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageMetadataServiceImpl.class);
    private final RqueueRedisTemplate<MessageMetadata> template;

    public RqueueMessageMetadataServiceImpl(RqueueRedisTemplate<MessageMetadata> template) {
        this.template = template;
    }

    @Autowired
    public RqueueMessageMetadataServiceImpl(RqueueConfig rqueueConfig) {
        this.template = new RqueueRedisTemplate(rqueueConfig.getConnectionFactory());
    }

    @Override
    public MessageMetadata get(String id) {
        return this.template.get(id);
    }

    @Override
    public List<MessageMetadata> findAll(Collection<String> ids) {
        return this.template.mget(ids).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void save(MessageMetadata messageMetadata, Duration duration) {
        Assert.notNull((Object)messageMetadata.getId(), (String)"messageMetadata id cannot be null");
        this.template.set(messageMetadata.getId(), messageMetadata, duration);
    }

    @Override
    public MessageMetadata getByMessageId(String queueName, String messageId) {
        String id = MessageUtils.getMessageMetaId(queueName, messageId);
        return this.get(id);
    }

    @Override
    public void deleteMessage(String queueName, String messageId, Duration duration) {
        String id = MessageUtils.getMessageMetaId(queueName, messageId);
        MessageMetadata messageMetadata = this.get(id);
        if (messageMetadata == null) {
            messageMetadata = new MessageMetadata(id, MessageStatus.DELETED);
        }
        messageMetadata.setDeleted(true);
        messageMetadata.setDeletedOn(System.currentTimeMillis());
        this.template.set(messageMetadata.getId(), messageMetadata, duration);
    }

    @Override
    public void delete(String id) {
        this.template.delete(id);
    }

    @Override
    public MessageMetadata getOrCreateMessageMetadata(RqueueMessage rqueueMessage) {
        MessageMetadata messageMetadata = this.getByMessageId(rqueueMessage.getQueueName(), rqueueMessage.getId());
        if (messageMetadata == null) {
            messageMetadata = new MessageMetadata(rqueueMessage, MessageStatus.ENQUEUED);
        }
        return messageMetadata;
    }
}

