/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.exception.UnknownSwitchCase;
import com.github.sonus21.rqueue.models.db.DeadLetterQueue;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.models.enums.ActionType;
import com.github.sonus21.rqueue.models.enums.DataType;
import com.github.sonus21.rqueue.models.enums.NavTab;
import com.github.sonus21.rqueue.models.response.DataViewResponse;
import com.github.sonus21.rqueue.models.response.RedisDataDetail;
import com.github.sonus21.rqueue.utils.DateTimeUtils;
import com.github.sonus21.rqueue.utils.MessageUtils;
import com.github.sonus21.rqueue.utils.RedisUtils;
import com.github.sonus21.rqueue.utils.StringUtils;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import com.github.sonus21.rqueue.web.service.RqueueQDetailService;
import com.github.sonus21.rqueue.web.service.RqueueSystemManagerService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RqueueQDetailServiceImpl
implements RqueueQDetailService {
    private final RqueueRedisTemplate<String> stringRqueueRedisTemplate;
    private final RqueueMessageTemplate rqueueMessageTemplate;
    private final RqueueSystemManagerService rqueueSystemManagerService;
    private final RqueueMessageMetadataService rqueueMessageMetadataService;

    @Autowired
    public RqueueQDetailServiceImpl(@Qualifier(value="stringRqueueRedisTemplate") RqueueRedisTemplate<String> stringRqueueRedisTemplate, RqueueMessageTemplate rqueueMessageTemplate, RqueueSystemManagerService rqueueSystemManagerService, RqueueMessageMetadataService rqueueMessageMetadataService) {
        this.stringRqueueRedisTemplate = stringRqueueRedisTemplate;
        this.rqueueMessageTemplate = rqueueMessageTemplate;
        this.rqueueSystemManagerService = rqueueSystemManagerService;
        this.rqueueMessageMetadataService = rqueueMessageMetadataService;
    }

    @Override
    public Map<String, List<Map.Entry<NavTab, RedisDataDetail>>> getQueueDataStructureDetails(List<QueueConfig> queueConfig) {
        return queueConfig.parallelStream().collect(Collectors.toMap(QueueConfig::getName, this::getQueueDataStructureDetail));
    }

    @Override
    public List<Map.Entry<NavTab, RedisDataDetail>> getQueueDataStructureDetail(QueueConfig queueConfig) {
        if (queueConfig == null) {
            return Collections.emptyList();
        }
        Long pending = this.stringRqueueRedisTemplate.getListSize(queueConfig.getQueueName());
        String processingQueueName = queueConfig.getProcessingQueueName();
        Long running = this.stringRqueueRedisTemplate.getZsetSize(processingQueueName);
        ArrayList queueRedisDataDetails = Lists.newArrayList((Object[])new Map.Entry[]{new AbstractMap.SimpleEntry<NavTab, RedisDataDetail>(NavTab.PENDING, new RedisDataDetail(queueConfig.getQueueName(), DataType.LIST, pending == null ? 0L : pending)), new AbstractMap.SimpleEntry<NavTab, RedisDataDetail>(NavTab.RUNNING, new RedisDataDetail(processingQueueName, DataType.ZSET, running == null ? 0L : running))});
        String timeQueueName = queueConfig.getDelayedQueueName();
        Long scheduled = this.stringRqueueRedisTemplate.getZsetSize(timeQueueName);
        queueRedisDataDetails.add(new AbstractMap.SimpleEntry<NavTab, RedisDataDetail>(NavTab.SCHEDULED, new RedisDataDetail(timeQueueName, DataType.ZSET, scheduled == null ? 0L : scheduled)));
        if (!CollectionUtils.isEmpty(queueConfig.getDeadLetterQueues())) {
            for (DeadLetterQueue dlq : queueConfig.getDeadLetterQueues()) {
                if (!dlq.isConsumerEnabled()) {
                    Long dlqSize = this.stringRqueueRedisTemplate.getListSize(dlq.getName());
                    queueRedisDataDetails.add(new AbstractMap.SimpleEntry<NavTab, RedisDataDetail>(NavTab.DEAD, new RedisDataDetail(dlq.getName(), DataType.LIST, dlqSize == null ? 0L : dlqSize)));
                    continue;
                }
                queueRedisDataDetails.add(new AbstractMap.SimpleEntry<NavTab, RedisDataDetail>(NavTab.DEAD, new RedisDataDetail(dlq.getName(), DataType.LIST, -1L)));
            }
        }
        return queueRedisDataDetails;
    }

    @Override
    public List<NavTab> getNavTabs(QueueConfig queueConfig) {
        ArrayList<NavTab> navTabs = new ArrayList<NavTab>();
        if (queueConfig != null) {
            navTabs.add(NavTab.PENDING);
            navTabs.add(NavTab.SCHEDULED);
            navTabs.add(NavTab.RUNNING);
            if (queueConfig.hasDeadLetterQueue()) {
                navTabs.add(NavTab.DEAD);
            }
        }
        return navTabs;
    }

    private List<ZSetOperations.TypedTuple<RqueueMessage>> readFromZset(String name, int pageNumber, int itemPerPage) {
        long start = (long)pageNumber * (long)itemPerPage;
        long end = start + (long)itemPerPage - 1L;
        return this.rqueueMessageTemplate.readFromZset(name, start, end).stream().map(e -> new DefaultTypedTuple(e, null)).collect(Collectors.toList());
    }

    private List<ZSetOperations.TypedTuple<RqueueMessage>> readFromList(String name, int pageNumber, int itemPerPage) {
        long start = (long)pageNumber * (long)itemPerPage;
        long end = start + (long)itemPerPage - 1L;
        return this.rqueueMessageTemplate.readFromList(name, start, end).stream().map(e -> new DefaultTypedTuple(e, null)).collect(Collectors.toList());
    }

    private List<ZSetOperations.TypedTuple<RqueueMessage>> readFromZetWithScore(String name, int pageNumber, int itemPerPage) {
        long start = (long)pageNumber * (long)itemPerPage;
        long end = start + (long)itemPerPage - 1L;
        return this.rqueueMessageTemplate.readFromZsetWithScore(name, start, end);
    }

    private List<List<Serializable>> buildRows(List<ZSetOperations.TypedTuple<RqueueMessage>> rqueueMessages, RowBuilder rowBuilder) {
        if (CollectionUtils.isEmpty(rqueueMessages)) {
            return Collections.emptyList();
        }
        HashMap<String, String> messageMetaIdToId = new HashMap<String, String>();
        for (ZSetOperations.TypedTuple<RqueueMessage> tuple : rqueueMessages) {
            RqueueMessage rqueueMessage = (RqueueMessage)tuple.getValue();
            assert (rqueueMessage != null);
            String messageMetaId = MessageUtils.getMessageMetaId(rqueueMessage.getQueueName(), rqueueMessage.getId());
            messageMetaIdToId.put(messageMetaId, rqueueMessage.getId());
        }
        List<MessageMetadata> vals = this.rqueueMessageMetadataService.findAll(messageMetaIdToId.keySet());
        HashMap<String, Boolean> msgIdToDeleted = new HashMap<String, Boolean>();
        for (MessageMetadata messageMetadata : vals) {
            String messageMetaId = messageMetadata.getId();
            String id = (String)messageMetaIdToId.get(messageMetaId);
            msgIdToDeleted.put(id, messageMetadata.isDeleted());
        }
        return rqueueMessages.stream().map(e -> rowBuilder.row((RqueueMessage)e.getValue(), msgIdToDeleted.getOrDefault(((RqueueMessage)e.getValue()).getId(), false), e.getScore())).collect(Collectors.toList());
    }

    @Override
    public DataViewResponse getExplorePageData(String src, String name, DataType type, int pageNumber, int itemPerPage) {
        QueueConfig queueConfig = this.rqueueSystemManagerService.getQueueConfig(src);
        DataViewResponse response = new DataViewResponse();
        boolean deadLetterQueue = queueConfig.isDeadLetterQueue(name);
        boolean timeQueue = queueConfig.getDelayedQueueName().equals(name);
        this.setHeadersIfRequired(deadLetterQueue, type, response, pageNumber);
        if (deadLetterQueue) {
            response.addAction(ActionType.DELETE);
        } else {
            response.addAction(ActionType.NONE);
        }
        switch (type) {
            case ZSET: {
                if (timeQueue) {
                    response.setRows(this.buildRows(this.readFromZset(name, pageNumber, itemPerPage), new ZsetRowBuilder(true)));
                    break;
                }
                response.setRows(this.buildRows(this.readFromZetWithScore(name, pageNumber, itemPerPage), new ZsetRowBuilder(false)));
                break;
            }
            case LIST: {
                response.setRows(this.buildRows(this.readFromList(name, pageNumber, itemPerPage), new ListRowBuilder(deadLetterQueue)));
                break;
            }
            default: {
                throw new UnknownSwitchCase(type.name());
            }
        }
        return response;
    }

    private DataViewResponse responseForSet(String name) {
        ArrayList<String> items = new ArrayList<String>(this.stringRqueueRedisTemplate.getMembers(name));
        DataViewResponse response = new DataViewResponse();
        response.setHeaders(Collections.singletonList("Item"));
        ArrayList<List<Serializable>> rows = new ArrayList<List<Serializable>>();
        for (Object e : items) {
            rows.add(Collections.singletonList(e.toString()));
        }
        response.setRows(rows);
        return response;
    }

    private DataViewResponse responseForKeyVal(String name) {
        DataViewResponse response = new DataViewResponse();
        response.setHeaders(Collections.singletonList("Value"));
        String val = this.stringRqueueRedisTemplate.get(name);
        List<List<Serializable>> rows = Collections.singletonList(Collections.singletonList(String.valueOf(val)));
        response.setRows(rows);
        return response;
    }

    private DataViewResponse responseForZset(String name, String key, int pageNumber, int itemPerPage) {
        DataViewResponse response = new DataViewResponse();
        int start = pageNumber * itemPerPage;
        int end = start + itemPerPage - 1;
        ArrayList<List<Serializable>> rows = new ArrayList<List<Serializable>>();
        if (!StringUtils.isEmpty(key)) {
            Double score = this.stringRqueueRedisTemplate.getZsetMemberScore(name, key);
            response.setHeaders(Collections.singletonList("Score"));
            rows.add(Collections.singletonList(score));
        } else {
            response.setHeaders(Arrays.asList("Item", "Score"));
            for (ZSetOperations.TypedTuple<String> tuple : this.stringRqueueRedisTemplate.zrangeWithScore(name, start, end)) {
                rows.add(Arrays.asList(String.valueOf(tuple.getValue()), tuple.getScore()));
            }
        }
        response.setRows(rows);
        return response;
    }

    private DataViewResponse responseForList(String name, int pageNumber, int itemPerPage) {
        DataViewResponse response = new DataViewResponse();
        response.setHeaders(Collections.singletonList("Item"));
        int start = pageNumber * itemPerPage;
        int end = start + itemPerPage - 1;
        ArrayList<List<Serializable>> rows = new ArrayList<List<Serializable>>();
        for (String s : this.stringRqueueRedisTemplate.lrange(name, start, end)) {
            List<String> singletonList = Collections.singletonList(String.valueOf(s));
            rows.add(singletonList);
        }
        response.setRows(rows);
        return response;
    }

    @Override
    public DataViewResponse viewData(String name, DataType type, String key, int pageNumber, int itemPerPage) {
        if (StringUtils.isEmpty(name)) {
            return DataViewResponse.createErrorMessage("Data name cannot be empty.");
        }
        if (DataType.isUnknown(type)) {
            return DataViewResponse.createErrorMessage("Data type is not provided.");
        }
        switch (type) {
            case SET: {
                return this.responseForSet(StringUtils.clean(name));
            }
            case ZSET: {
                return this.responseForZset(StringUtils.clean(name), StringUtils.clean(key), pageNumber, itemPerPage);
            }
            case LIST: {
                return this.responseForList(StringUtils.clean(name), pageNumber, itemPerPage);
            }
            case KEY: {
                return this.responseForKeyVal(StringUtils.clean(name));
            }
        }
        throw new UnknownSwitchCase(type.name());
    }

    private void setHeadersIfRequired(boolean deadLetterQueue, DataType type, DataViewResponse response, int pageNumber) {
        if (pageNumber != 0) {
            return;
        }
        ArrayList headers = Lists.newArrayList((Object[])new String[]{"Id", "Message"});
        if (DataType.ZSET == type) {
            headers.add("Time Left");
        }
        if (!deadLetterQueue) {
            headers.add("Action");
        } else {
            headers.add("AddedOn");
        }
        response.setHeaders(headers);
    }

    @Override
    public List<List<Object>> getRunningTasks() {
        List<QueueConfig> queueConfigs = this.rqueueSystemManagerService.getSortedQueueConfigs();
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        List<Object> result = new ArrayList();
        if (!CollectionUtils.isEmpty(queueConfigs)) {
            result = RedisUtils.executePipeLine(this.stringRqueueRedisTemplate.getRedisTemplate(), (connection, keySerializer, valueSerializer) -> {
                for (QueueConfig queueConfig : queueConfigs) {
                    connection.zCard(queueConfig.getProcessingQueueName().getBytes());
                }
            });
        }
        rows.add(Arrays.asList("Queue", "Processing [ZSET]", "Size"));
        for (int i = 0; i < queueConfigs.size(); ++i) {
            QueueConfig queueConfig = queueConfigs.get(i);
            rows.add(Arrays.asList(queueConfig.getName(), queueConfig.getProcessingQueueName(), result.get(i)));
        }
        return rows;
    }

    @Override
    public List<List<Object>> getWaitingTasks() {
        List<QueueConfig> queueConfigs = this.rqueueSystemManagerService.getSortedQueueConfigs();
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        List<Object> result = new ArrayList();
        if (!CollectionUtils.isEmpty(queueConfigs)) {
            result = RedisUtils.executePipeLine(this.stringRqueueRedisTemplate.getRedisTemplate(), (connection, keySerializer, valueSerializer) -> {
                for (QueueConfig queueConfig : queueConfigs) {
                    connection.lLen(queueConfig.getQueueName().getBytes());
                }
            });
        }
        rows.add(Arrays.asList("Queue", "Queue [LIST]", "Size"));
        for (int i = 0; i < queueConfigs.size(); ++i) {
            QueueConfig queueConfig = queueConfigs.get(i);
            rows.add(Arrays.asList(queueConfig.getName(), queueConfig.getQueueName(), result.get(i)));
        }
        return rows;
    }

    @Override
    public List<List<Object>> getScheduledTasks() {
        List<QueueConfig> queueConfigs = this.rqueueSystemManagerService.getSortedQueueConfigs();
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        List<Object> result = new ArrayList();
        if (!CollectionUtils.isEmpty(queueConfigs)) {
            result = RedisUtils.executePipeLine(this.stringRqueueRedisTemplate.getRedisTemplate(), (connection, keySerializer, valueSerializer) -> {
                for (QueueConfig queueConfig : queueConfigs) {
                    connection.zCard(queueConfig.getDelayedQueueName().getBytes());
                }
            });
        }
        rows.add(Arrays.asList("Queue", "Scheduled [ZSET]", "Size"));
        for (int i = 0; i < queueConfigs.size(); ++i) {
            QueueConfig queueConfig = queueConfigs.get(i);
            rows.add(Arrays.asList(queueConfig.getName(), queueConfig.getDelayedQueueName(), result.get(i)));
        }
        return rows;
    }

    private void addRows(List<Object> result, List<List<Object>> rows, List<Map.Entry<QueueConfig, String>> queueConfigAndDlq) {
        int j = 0;
        for (int i = 0; i < queueConfigAndDlq.size(); ++i) {
            Map.Entry<QueueConfig, String> entry = queueConfigAndDlq.get(i);
            QueueConfig queueConfig = entry.getKey();
            if (entry.getValue().isEmpty()) {
                rows.add(Arrays.asList(queueConfig.getName(), "", ""));
                continue;
            }
            String name = "";
            if (i == 0 || !queueConfig.getQueueName().equals(queueConfigAndDlq.get(i - 1).getKey().getQueueName())) {
                name = queueConfig.getName();
            }
            rows.add(Arrays.asList(name, entry.getValue(), result.get(j++)));
        }
    }

    @Override
    public List<List<Object>> getDeadLetterTasks() {
        List<QueueConfig> queueConfigs = this.rqueueSystemManagerService.getSortedQueueConfigs();
        ArrayList<Map.Entry<QueueConfig, String>> queueConfigAndDlq = new ArrayList<Map.Entry<QueueConfig, String>>();
        for (QueueConfig queueConfig : queueConfigs) {
            if (queueConfig.hasDeadLetterQueue()) {
                for (DeadLetterQueue dlq : queueConfig.getDeadLetterQueues()) {
                    queueConfigAndDlq.add(new AbstractMap.SimpleEntry<QueueConfig, String>(queueConfig, dlq.getName()));
                }
                continue;
            }
            queueConfigAndDlq.add(new AbstractMap.SimpleEntry<QueueConfig, String>(queueConfig, ""));
        }
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        ArrayList<Object> result = new ArrayList();
        if (!CollectionUtils.isEmpty(queueConfigAndDlq)) {
            result = RedisUtils.executePipeLine(this.stringRqueueRedisTemplate.getRedisTemplate(), (connection, keySerializer, valueSerializer) -> {
                for (Map.Entry entry : queueConfigAndDlq) {
                    if (((String)entry.getValue()).isEmpty()) continue;
                    connection.lLen(((String)entry.getValue()).getBytes());
                }
            });
        }
        rows.add(Arrays.asList("Queue", "Dead Letter Queue [LIST]", "Size"));
        this.addRows(result, rows, queueConfigAndDlq);
        return rows;
    }

    class ZsetRowBuilder
    implements RowBuilder {
        private final long currentTime;
        private final boolean timeQueue;

        ZsetRowBuilder(boolean timeQueue) {
            this.timeQueue = timeQueue;
            this.currentTime = System.currentTimeMillis();
        }

        @Override
        public List<Serializable> row(RqueueMessage rqueueMessage, boolean deleted, Double score) {
            ArrayList row = Lists.newArrayList((Object[])new Serializable[]{rqueueMessage.getId(), rqueueMessage.toString()});
            if (this.timeQueue) {
                row.add(DateTimeUtils.milliToHumanRepresentation(rqueueMessage.getProcessAt() - this.currentTime));
            } else {
                row.add(DateTimeUtils.milliToHumanRepresentation(score.longValue() - this.currentTime));
            }
            if (!deleted) {
                row.add(ActionType.DELETE);
            } else {
                row.add("");
            }
            return row;
        }
    }

    static class ListRowBuilder
    implements RowBuilder {
        private final boolean deadLetterQueue;

        ListRowBuilder(boolean deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
        }

        @Override
        public List<Serializable> row(RqueueMessage rqueueMessage, boolean deleted, Double score) {
            ArrayList row = Lists.newArrayList((Object[])new Serializable[]{rqueueMessage.getId(), rqueueMessage.toString()});
            if (!this.deadLetterQueue) {
                if (deleted) {
                    row.add("");
                } else {
                    row.add(ActionType.DELETE);
                }
            } else {
                row.add(DateTimeUtils.formatMilliToString(rqueueMessage.getReEnqueuedAt()));
            }
            return row;
        }
    }

    private static interface RowBuilder {
        public List<Serializable> row(RqueueMessage var1, boolean var2, Double var3);
    }
}

