/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.MessageScheduler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledQueueMessageScheduler
extends MessageScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduledQueueMessageScheduler.class);

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected long getNextScheduleTime(String queueName, Long value) {
        long currentTime = System.currentTimeMillis();
        if (value == null) {
            return currentTime + this.rqueueSchedulerConfig.getScheduledMessageTimeIntervalInMilli();
        }
        if (value < currentTime) {
            return currentTime;
        }
        return currentTime + this.rqueueSchedulerConfig.getScheduledMessageTimeIntervalInMilli();
    }

    @Override
    protected String getChannelName(String queueName) {
        return EndpointRegistry.get(queueName).getScheduledQueueChannelName();
    }

    @Override
    protected String getZsetName(String queueName) {
        return EndpointRegistry.get(queueName).getScheduledQueueName();
    }

    @Override
    protected String getThreadNamePrefix() {
        return "scheduledQueueMsgScheduler-";
    }

    @Override
    protected int getThreadPoolSize() {
        return this.rqueueSchedulerConfig.getScheduledMessageThreadPoolSize();
    }

    @Override
    protected boolean isProcessingQueue(String queueName) {
        return false;
    }
}

