/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.context;

import com.github.sonus21.rqueue.core.context.Context;

public class DefaultContext
implements Context {
    public static final Context EMPTY = new DefaultContext(null, null, null);
    private final Context parentContext;
    private final Object key;
    private final Object value;

    private DefaultContext(Context parentContext, Object key, Object value) {
        this.parentContext = parentContext;
        this.key = key;
        this.value = value;
    }

    public static Context withValue(Context parentContext, Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        return new DefaultContext(parentContext, key, value);
    }

    @Override
    public Object getValue(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        if (this == EMPTY) {
            return null;
        }
        if (key.equals(this.key)) {
            return this.value;
        }
        if (this.parentContext != null) {
            return this.parentContext.getValue(key);
        }
        return null;
    }
}

