/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageSender;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.BaseMessageSender;
import com.github.sonus21.rqueue.core.support.RqueueMessageUtils;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.MessageMoveResult;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.Validator;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class RqueueMessageSenderImpl
extends BaseMessageSender
implements RqueueMessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageSenderImpl.class);

    public RqueueMessageSenderImpl(RqueueMessageTemplate messageTemplate, MessageConverter messageConverter, MessageHeaders messageHeaders) {
        super(messageTemplate, messageConverter, messageHeaders);
    }

    @Override
    public boolean enqueue(String queueName, Object message) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        return this.pushMessage(queueName, null, message, null, null) != null;
    }

    @Override
    public boolean enqueueWithRetry(String queueName, Object message, int retryCount) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        return this.pushMessage(queueName, null, message, retryCount, null) != null;
    }

    @Override
    public boolean enqueueWithPriority(String queueName, String priority, Object message) {
        Validator.validateQueue(queueName);
        Validator.validatePriority(priority);
        Validator.validateMessage(message);
        return this.pushMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), null, message, null, null) != null;
    }

    @Override
    public boolean enqueueIn(String queueName, Object message, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, null, message, null, delayInMilliSecs) != null;
    }

    @Override
    public boolean enqueueInWithRetry(String queueName, Object message, int retryCount, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, null, message, retryCount, delayInMilliSecs) != null;
    }

    @Override
    public boolean enqueueInWithPriority(String queueName, String priority, Object message, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validatePriority(priority);
        Validator.validateMessage(message);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), null, message, null, delayInMilliSecs) != null;
    }

    @Override
    public List<Object> getAllMessages(String queueName) {
        ArrayList<Object> messages = new ArrayList<Object>();
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        for (RqueueMessage message : this.messageTemplate.getAllMessages(queueDetail.getQueueName(), queueDetail.getProcessingQueueName(), queueDetail.getScheduledQueueName())) {
            messages.add(RqueueMessageUtils.convertMessageToObject(message, this.messageConverter));
        }
        return messages;
    }

    @Override
    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public List<MessageConverter> getMessageConverters() {
        return ImmutableList.of((Object)this.messageConverter);
    }

    @Override
    public boolean moveMessageFromDeadLetterToQueue(String deadLetterQueueName, String queueName, Integer maxMessages) {
        return this.moveMessageListToList(deadLetterQueueName, queueName, maxMessages).isSuccess();
    }

    @Override
    public boolean moveMessageFromDeadLetterToQueue(String deadLetterQueueName, String queueName) {
        return this.moveMessageListToList(deadLetterQueueName, queueName, null).isSuccess();
    }

    private MessageMoveResult moveMessageListToList(String sourceQueue, String destinationQueue, Integer maxMessage) {
        Assert.notNull((Object)sourceQueue, (String)"sourceQueue must not be null");
        Assert.notNull((Object)destinationQueue, (String)"destinationQueue must not be null");
        Assert.isTrue((!sourceQueue.equals(destinationQueue) ? 1 : 0) != 0, (String)"sourceQueue and destinationQueue must be different");
        Integer messageCount = maxMessage;
        if (messageCount == null) {
            messageCount = 100;
        }
        Assert.isTrue((messageCount > 0 ? 1 : 0) != 0, (String)"maxMessage must be greater than zero");
        return this.messageTemplate.moveMessageListToList(sourceQueue, destinationQueue, messageCount);
    }

    @Override
    public boolean deleteAllMessages(String queueName) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        try {
            this.deleteAllMessages(queueDetail);
            return true;
        }
        catch (Exception e) {
            log.error("DeleteAllMessages failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public void registerQueue(String queueName, String ... priorities) {
        this.registerQueueInternal(queueName, priorities);
    }
}

