/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.middleware;

import com.github.sonus21.rqueue.core.Job;
import com.github.sonus21.rqueue.core.middleware.TimeProviderMiddleware;
import com.github.sonus21.rqueue.models.enums.JobStatus;
import com.github.sonus21.rqueue.utils.StringUtils;
import java.io.Serializable;
import java.util.concurrent.Callable;

public interface LockMiddleware
extends TimeProviderMiddleware {
    public static final String REASON = "Lock could not be acquired";

    public String acquireLock(Job var1);

    public void releaseLock(Job var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void handle(Job job, Callable<Void> callable) throws Exception {
        String lockIdentifier = null;
        try {
            lockIdentifier = this.acquireLock(job);
            if (!StringUtils.isEmpty(lockIdentifier)) {
                callable.call();
            } else {
                job.release(JobStatus.FAILED, (Serializable)((Object)REASON), this.releaseIn(job));
            }
        }
        finally {
            this.releaseLock(job, lockIdentifier);
        }
    }
}

