/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.middleware;

import com.github.sonus21.rqueue.core.Job;
import com.github.sonus21.rqueue.core.middleware.Middleware;
import java.time.Duration;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilerMiddleware
implements Middleware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfilerMiddleware.class);

    protected void report(Job job, Duration executionTime) {
        log.info("Queue: {}, Job: {}  took {}Ms", new Object[]{job.getRqueueMessage().getQueueName(), job.getId(), executionTime.toMillis()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Job job, Callable<Void> next) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            next.call();
        }
        finally {
            this.report(job, Duration.ofMillis(System.currentTimeMillis() - startTime));
        }
    }
}

