/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.core.RqueueBeanProvider;
import com.github.sonus21.rqueue.core.middleware.Middleware;
import com.github.sonus21.rqueue.listener.PostProcessingHandler;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.listener.RqueueMessagePoller;
import com.github.sonus21.rqueue.utils.QueueThreadPool;
import com.github.sonus21.rqueue.utils.TimeoutUtils;
import java.util.Collections;
import java.util.List;
import org.slf4j.event.Level;
import org.springframework.messaging.MessageHeaders;

class DefaultRqueuePoller
extends RqueueMessagePoller {
    private final QueueDetail queueDetail;
    private final QueueThreadPool queueThreadPool;

    DefaultRqueuePoller(QueueDetail queueDetail, QueueThreadPool queueThreadPool, RqueueBeanProvider rqueueBeanProvider, RqueueMessageListenerContainer.QueueStateMgr queueStateMgr, List<Middleware> middlewares, long pollingInterval, long backoffTime, PostProcessingHandler postProcessingHandler, MessageHeaders messageHeaders) {
        super(queueDetail.getName(), rqueueBeanProvider, queueStateMgr, middlewares, pollingInterval, backoffTime, postProcessingHandler, messageHeaders);
        this.queueDetail = queueDetail;
        this.queueThreadPool = queueThreadPool;
        this.queues = Collections.singletonList(queueDetail.getName());
    }

    @Override
    long getSemaphoreWaitTime() {
        return this.pollingInterval;
    }

    @Override
    void deactivate(int index, String queue, RqueueMessagePoller.DeactivateType deactivateType) {
        if (deactivateType == RqueueMessagePoller.DeactivateType.SEMAPHORE_UNAVAILABLE || deactivateType == RqueueMessagePoller.DeactivateType.NO_MESSAGE) {
            TimeoutUtils.sleepLog(this.pollingInterval, false);
        } else if (deactivateType == RqueueMessagePoller.DeactivateType.POLL_FAILED) {
            TimeoutUtils.sleepLog(this.backoffTime, false);
        }
    }

    @Override
    public void start() {
        this.log(Level.DEBUG, "Running Queue {}", null, this.queueDetail.getName());
        while (true) {
            try {
                while (true) {
                    if (this.eligibleForPolling(this.queueDetail.getName())) {
                        this.poll(-1, this.queueDetail.getName(), this.queueDetail, this.queueThreadPool);
                        continue;
                    }
                    if (this.shouldExit()) {
                        return;
                    }
                    this.deactivate(-1, this.queueDetail.getName(), RqueueMessagePoller.DeactivateType.NO_MESSAGE);
                }
            }
            catch (Exception e) {
                this.log(Level.ERROR, "Error in poller", e, new Object[0]);
                if (!this.shouldExit()) continue;
                return;
            }
            break;
        }
    }
}

