/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.listener.PostProcessingHandler;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.utils.QueueThreadPool;
import com.github.sonus21.rqueue.utils.RetryableRunnable;
import org.slf4j.Logger;

abstract class MessageContainerBase
extends RetryableRunnable<Object> {
    protected final RqueueMessageListenerContainer.QueueStateMgr queueStateMgr;

    MessageContainerBase(Logger log, String groupName, RqueueMessageListenerContainer.QueueStateMgr queueStateMgr) {
        super(log, groupName);
        this.queueStateMgr = queueStateMgr;
    }

    boolean isQueueActive(String queueName) {
        return this.queueStateMgr.isQueueActive(queueName);
    }

    boolean eligibleForPolling(String queueName) {
        return this.isQueueNotPaused(queueName) && this.isQueueActive(queueName);
    }

    boolean isQueueNotPaused(String queueName) {
        return !this.isQueuePaused(queueName);
    }

    boolean isQueuePaused(String queueName) {
        return this.queueStateMgr.isQueuePaused(queueName);
    }

    protected void release(PostProcessingHandler postProcessingHandler, QueueThreadPool queueThreadPool, QueueDetail queueDetail, RqueueMessage message) {
        queueThreadPool.release();
        postProcessingHandler.parkMessageForRetry(message, message.getFailureCount(), -1L, queueDetail);
    }
}

