/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.request;

import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.models.SerializableBase;
import com.github.sonus21.rqueue.models.enums.AggregationType;
import com.github.sonus21.rqueue.models.enums.ChartDataType;
import com.github.sonus21.rqueue.models.enums.ChartType;
import com.github.sonus21.rqueue.models.response.ChartDataResponse;
import java.util.List;
import lombok.Generated;

public class ChartDataRequest
extends SerializableBase {
    private static final long serialVersionUID = 7727090378318819986L;
    private ChartType type;
    private String queue;
    private int number;
    private AggregationType aggregationType;
    private List<ChartDataType> dateTypes;

    public ChartDataRequest(ChartType chartType, AggregationType aggregationType) {
        this.type = chartType;
        this.aggregationType = aggregationType;
    }

    public int numberOfDays(RqueueWebConfig rqueueWebConfig) {
        int n = this.number;
        if (this.aggregationType == AggregationType.MONTHLY) {
            n = this.number * 30;
        } else if (this.aggregationType == AggregationType.WEEKLY) {
            n = this.number * 7;
        }
        if (n <= 0 || n > rqueueWebConfig.getHistoryDay()) {
            return rqueueWebConfig.getHistoryDay();
        }
        return n;
    }

    public ChartDataResponse validate() {
        ChartDataResponse chartDataResponse = new ChartDataResponse();
        if (this.getType() == null) {
            chartDataResponse.set(1, "type cannot be null");
            return chartDataResponse;
        }
        if (this.getAggregationType() == null) {
            chartDataResponse.set(1, "aggregationType cannot be null");
            return chartDataResponse;
        }
        return null;
    }

    @Generated
    public ChartType getType() {
        return this.type;
    }

    @Generated
    public String getQueue() {
        return this.queue;
    }

    @Generated
    public int getNumber() {
        return this.number;
    }

    @Generated
    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Generated
    public List<ChartDataType> getDateTypes() {
        return this.dateTypes;
    }

    @Generated
    public void setType(ChartType type) {
        this.type = type;
    }

    @Generated
    public void setQueue(String queue) {
        this.queue = queue;
    }

    @Generated
    public void setNumber(int number) {
        this.number = number;
    }

    @Generated
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    @Generated
    public void setDateTypes(List<ChartDataType> dateTypes) {
        this.dateTypes = dateTypes;
    }

    @Generated
    public ChartDataRequest() {
    }

    @Generated
    public String toString() {
        return "ChartDataRequest(type=" + (Object)((Object)this.getType()) + ", queue=" + this.getQueue() + ", number=" + this.getNumber() + ", aggregationType=" + (Object)((Object)this.getAggregationType()) + ", dateTypes=" + this.getDateTypes() + ")";
    }
}

