/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public final class DateTimeUtils {
    private static final DateTimeFormatter simple = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm");

    DateTimeUtils() {
    }

    private static String hourString(long hour) {
        if (hour > 1L) {
            return hour + " Hours";
        }
        return hour + " Hour";
    }

    private static String minuteString(long minutes) {
        if (minutes > 1L) {
            return minutes + " Minutes";
        }
        return minutes + " Minute";
    }

    private static String secondString(long seconds) {
        if (seconds > 1L) {
            return seconds + " Seconds";
        }
        return seconds + " Second";
    }

    private static String dayString(long days) {
        if (days > 1L) {
            return days + " Days";
        }
        return days + " Day";
    }

    private static String formatDay(long days, long hours, long minutes, long seconds) {
        if (hours == 0L && minutes == 0L && seconds == 0L) {
            return DateTimeUtils.dayString(days);
        }
        if (minutes == 0L && seconds == 0L) {
            return String.format("%s, %s", DateTimeUtils.dayString(days), DateTimeUtils.hourString(hours));
        }
        if (seconds == 0L) {
            return String.format("%s, %s, %s", DateTimeUtils.dayString(days), DateTimeUtils.hourString(hours), DateTimeUtils.minuteString(minutes));
        }
        return String.format("%s, %s, %s, %s", DateTimeUtils.dayString(days), DateTimeUtils.hourString(hours), DateTimeUtils.minuteString(minutes), DateTimeUtils.secondString(seconds));
    }

    private static String formatHour(long hours, long minutes, long seconds) {
        if (minutes == 0L && seconds == 0L) {
            return DateTimeUtils.hourString(hours);
        }
        if (seconds == 0L) {
            return String.format("%s, %s", DateTimeUtils.hourString(hours), DateTimeUtils.minuteString(minutes));
        }
        return String.format("%s, %s, %s", DateTimeUtils.hourString(hours), DateTimeUtils.minuteString(minutes), DateTimeUtils.secondString(seconds));
    }

    public static String milliToHumanRepresentation(long millisecond) {
        long millis = millisecond;
        String prefix = "";
        if (millis < 0L) {
            prefix = "- ";
            millis = -1L * millis;
        }
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        if (days != 0L) {
            return prefix + DateTimeUtils.formatDay(days, hours, minutes, seconds);
        }
        if (hours != 0L) {
            return prefix + DateTimeUtils.formatHour(hours, minutes, seconds);
        }
        if (minutes != 0L) {
            if (seconds == 0L) {
                return prefix + DateTimeUtils.minuteString(minutes);
            }
            return prefix + String.format("%s, %s", DateTimeUtils.minuteString(minutes), DateTimeUtils.secondString(seconds));
        }
        return prefix + DateTimeUtils.secondString(seconds);
    }

    public static String formatMilliToString(Long milli) {
        if (milli == null) {
            return "";
        }
        Instant instant = Instant.ofEpochMilli(milli);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.of("UTC"));
        return zonedDateTime.format(simple);
    }

    public static LocalDate localDateFromMilli(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneOffset.UTC).toLocalDate();
    }

    public static LocalDate today() {
        return LocalDate.now(ZoneOffset.UTC);
    }
}

