/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.utils.QueueThreadPool;
import com.github.sonus21.rqueue.utils.StringUtils;
import com.github.sonus21.rqueue.utils.TimeoutUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public final class ThreadUtils {
    private ThreadUtils() {
    }

    public static ThreadPoolTaskScheduler createTaskScheduler(int poolSize, String threadPrefix, int terminationTime) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setBeanName(threadPrefix.substring(0, threadPrefix.length() - 1));
        scheduler.setPoolSize(poolSize);
        scheduler.setThreadNamePrefix(threadPrefix);
        scheduler.setAwaitTerminationSeconds(terminationTime);
        scheduler.setRemoveOnCancelPolicy(true);
        scheduler.afterPropertiesSet();
        return scheduler;
    }

    public static ThreadPoolTaskExecutor createTaskExecutor(String beanName, String threadPrefix, int corePoolSize, int maxPoolSize, int queueCapacity) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setThreadNamePrefix(threadPrefix);
        threadPoolTaskExecutor.setBeanName(beanName);
        if (corePoolSize > 0) {
            threadPoolTaskExecutor.setCorePoolSize(corePoolSize);
            threadPoolTaskExecutor.setAllowCoreThreadTimeOut(true);
            threadPoolTaskExecutor.setMaxPoolSize(Math.max(corePoolSize, maxPoolSize));
            threadPoolTaskExecutor.setQueueCapacity(queueCapacity);
        }
        threadPoolTaskExecutor.afterPropertiesSet();
        return threadPoolTaskExecutor;
    }

    private static void waitForShutdown(Logger log, Future<?> future, long waitTimeInMillis, String msg, Object ... msgParams) {
        boolean completedOrCancelled;
        boolean bl = completedOrCancelled = future.isCancelled() || future.isDone();
        if (completedOrCancelled) {
            return;
        }
        try {
            future.get(waitTimeInMillis, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException | ExecutionException | TimeoutException e) {
            log.debug(msg, (Object)msgParams, (Object)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void waitForTermination(Logger log, Future<?> future, long waitTimeInMillis, String msg, Object ... msgParams) {
        ScheduledFuture f;
        boolean completedOrCancelled;
        if (future == null) {
            return;
        }
        boolean bl = completedOrCancelled = future.isCancelled() || future.isDone();
        if (!completedOrCancelled && future instanceof ScheduledFuture && (f = (ScheduledFuture)future).getDelay(TimeUnit.MILLISECONDS) > 100L) {
            return;
        }
        ThreadUtils.waitForShutdown(log, future, waitTimeInMillis, msg, msgParams);
    }

    public static boolean waitForWorkerTermination(Collection<QueueThreadPool> queueThreadPools, long waitTime) {
        long endTime = System.currentTimeMillis() + waitTime;
        ArrayList<QueueThreadPool> remaining = new ArrayList<QueueThreadPool>(queueThreadPools);
        while (System.currentTimeMillis() < endTime && !remaining.isEmpty()) {
            ArrayList<QueueThreadPool> newRemaining = new ArrayList<QueueThreadPool>();
            for (QueueThreadPool queueThreadPool : remaining) {
                if (queueThreadPool.allTasksCompleted()) continue;
                newRemaining.add(queueThreadPool);
            }
            if (!newRemaining.isEmpty()) {
                TimeoutUtils.sleep(10L);
            }
            remaining = newRemaining;
        }
        return remaining.isEmpty();
    }

    public static String getWorkerName(String name) {
        String camelCase = StringUtils.getBeanName(name);
        return camelCase + "Listener";
    }
}

