/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.controller;

import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.utils.condition.ReactiveEnabled;
import com.github.sonus21.rqueue.web.controller.BaseReactiveController;
import com.github.sonus21.rqueue.web.service.RqueueViewControllerService;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolver;
import reactor.core.publisher.Mono;

@Controller
@RequestMapping(path={"${rqueue.web.url.prefix:}rqueue"})
@Conditional(value={ReactiveEnabled.class})
public class ReactiveRqueueViewController
extends BaseReactiveController {
    private final ViewResolver rqueueViewResolver;
    private final RqueueViewControllerService rqueueViewControllerService;

    @Autowired
    public ReactiveRqueueViewController(RqueueWebConfig rqueueWebConfig, RqueueViewControllerService rqueueViewControllerService, @Qualifier(value="reactiveRqueueViewResolver") ViewResolver rqueueViewResolver) {
        super(rqueueWebConfig);
        this.rqueueViewResolver = rqueueViewResolver;
        this.rqueueViewControllerService = rqueueViewControllerService;
    }

    private String xForwardedPrefix(ServerHttpRequest request) {
        return request.getHeaders().getFirst("x-forwarded-prefix");
    }

    @GetMapping
    public Mono<View> index(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (this.isEnabled(response)) {
            this.rqueueViewControllerService.index(model, this.xForwardedPrefix(request));
            return this.rqueueViewResolver.resolveViewName("index", Locale.ENGLISH);
        }
        return null;
    }

    @GetMapping(value={"queues"})
    public Mono<View> queues(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (this.isEnabled(response)) {
            this.rqueueViewControllerService.queues(model, this.xForwardedPrefix(request));
            return this.rqueueViewResolver.resolveViewName("queues", Locale.ENGLISH);
        }
        return null;
    }

    @GetMapping(value={"queues/{queueName}"})
    public Mono<View> queueDetail(@PathVariable String queueName, Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (this.isEnabled(response)) {
            this.rqueueViewControllerService.queueDetail(model, this.xForwardedPrefix(request), queueName);
            return this.rqueueViewResolver.resolveViewName("queue_detail", Locale.ENGLISH);
        }
        return null;
    }

    @GetMapping(value={"running"})
    public Mono<View> running(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (this.isEnabled(response)) {
            this.rqueueViewControllerService.running(model, this.xForwardedPrefix(request));
            return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
        }
        return null;
    }

    @GetMapping(value={"scheduled"})
    public Mono<View> scheduled(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (this.isEnabled(response)) {
            this.rqueueViewControllerService.scheduled(model, this.xForwardedPrefix(request));
            return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
        }
        return null;
    }

    @GetMapping(value={"dead"})
    public Mono<View> dead(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (this.isEnabled(response)) {
            this.rqueueViewControllerService.dead(model, this.xForwardedPrefix(request));
            return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
        }
        return null;
    }

    @GetMapping(value={"pending"})
    public Mono<View> pending(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (this.isEnabled(response)) {
            this.rqueueViewControllerService.pending(model, this.xForwardedPrefix(request));
            return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
        }
        return null;
    }

    @GetMapping(value={"utility"})
    public Mono<View> utility(Model model, ServerHttpRequest request, ServerHttpResponse response) throws Exception {
        if (this.isEnabled(response)) {
            this.rqueueViewControllerService.utility(model, this.xForwardedPrefix(request));
            return this.rqueueViewResolver.resolveViewName("utility", Locale.ENGLISH);
        }
        return null;
    }
}

