/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.common.RqueueLockManager;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.support.RqueueMessageUtils;
import com.github.sonus21.rqueue.dao.RqueueMessageMetadataDao;
import com.github.sonus21.rqueue.dao.RqueueStringDao;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.models.enums.MessageStatus;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class RqueueMessageMetadataServiceImpl
implements RqueueMessageMetadataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageMetadataServiceImpl.class);
    private final RqueueMessageMetadataDao rqueueMessageMetadataDao;
    private final RqueueStringDao rqueueStringDao;
    private final RqueueLockManager lockManager;

    @Autowired
    public RqueueMessageMetadataServiceImpl(RqueueMessageMetadataDao rqueueMessageMetadataDao, RqueueStringDao rqueueStringDao, RqueueLockManager rqueueLockManager) {
        this.rqueueMessageMetadataDao = rqueueMessageMetadataDao;
        this.rqueueStringDao = rqueueStringDao;
        this.lockManager = rqueueLockManager;
    }

    @Override
    public MessageMetadata get(String id) {
        return this.rqueueMessageMetadataDao.get(id);
    }

    @Override
    public void delete(String id) {
        this.rqueueMessageMetadataDao.delete(id);
    }

    @Override
    public void deleteAll(Collection<String> ids) {
        this.rqueueMessageMetadataDao.deleteAll(ids);
    }

    @Override
    public List<MessageMetadata> findAll(Collection<String> ids) {
        return this.rqueueMessageMetadataDao.findAll(ids).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void save(MessageMetadata messageMetadata, Duration duration) {
        this.rqueueMessageMetadataDao.save(messageMetadata, duration);
    }

    @Override
    public MessageMetadata getByMessageId(String queueName, String messageId) {
        String id = RqueueMessageUtils.getMessageMetaId(queueName, messageId);
        return this.rqueueMessageMetadataDao.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteMessage(String queueName, String messageId, Duration duration) {
        String lockValue = UUID.randomUUID().toString();
        try {
            if (this.lockManager.acquireLock(messageId, lockValue, Duration.ofSeconds(1L))) {
                String id = RqueueMessageUtils.getMessageMetaId(queueName, messageId);
                MessageMetadata messageMetadata = this.rqueueMessageMetadataDao.get(id);
                if (messageMetadata == null) {
                    messageMetadata = new MessageMetadata(id, MessageStatus.DELETED);
                }
                messageMetadata.setDeleted(true);
                messageMetadata.setDeletedOn(System.currentTimeMillis());
                this.save(messageMetadata, duration);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lockManager.releaseLock(messageId, lockValue);
        }
        return false;
    }

    @Override
    public MessageMetadata getOrCreateMessageMetadata(RqueueMessage rqueueMessage) {
        MessageMetadata messageMetadata = this.getByMessageId(rqueueMessage.getQueueName(), rqueueMessage.getId());
        if (messageMetadata == null) {
            messageMetadata = new MessageMetadata(rqueueMessage, MessageStatus.ENQUEUED);
        }
        return messageMetadata;
    }

    @Override
    public Mono<Boolean> saveReactive(MessageMetadata messageMetadata, Duration duration) {
        return this.rqueueMessageMetadataDao.saveReactive(messageMetadata, duration);
    }

    @Override
    public List<ZSetOperations.TypedTuple<MessageMetadata>> readMessageMetadataForQueue(String queueName, long start, long end) {
        List<ZSetOperations.TypedTuple<String>> metaIds = this.rqueueStringDao.readFromOrderedSetWithScoreBetween(queueName, start, end);
        Map<String, Double> metaIdToScoreMap = metaIds.stream().collect(Collectors.toMap(ZSetOperations.TypedTuple::getValue, ZSetOperations.TypedTuple::getScore));
        List<MessageMetadata> messageMetadata = this.findAll(metaIdToScoreMap.keySet());
        return messageMetadata.stream().map(metadata -> {
            Double score = (Double)metaIdToScoreMap.get(metadata.getId());
            if (score == null) {
                return null;
            }
            return new DefaultTypedTuple(metadata, score);
        }).filter(Objects::nonNull).sorted(Comparator.comparingLong(e1 -> -((MessageMetadata)Objects.requireNonNull(e1.getValue())).getUpdatedOn())).collect(Collectors.toList());
    }

    @Override
    public void saveMessageMetadataForQueue(String queueName, MessageMetadata messageMetadata, Long ttlInMillisecond) {
        messageMetadata.setUpdatedOn(System.currentTimeMillis());
        this.save(messageMetadata, Duration.ofMillis(ttlInMillisecond));
        this.rqueueStringDao.addToOrderedSetWithScore(queueName, messageMetadata.getId(), -(System.currentTimeMillis() + ttlInMillisecond));
    }

    @Override
    public void deleteQueueMessages(String queueName, long before) {
        this.rqueueStringDao.deleteAll(queueName, -before, 0L);
    }
}

