/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.models.Pair;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.models.enums.AggregationType;
import com.github.sonus21.rqueue.models.enums.ChartDataType;
import com.github.sonus21.rqueue.models.enums.DataType;
import com.github.sonus21.rqueue.models.enums.NavTab;
import com.github.sonus21.rqueue.models.response.RedisDataDetail;
import com.github.sonus21.rqueue.web.service.RqueueQDetailService;
import com.github.sonus21.rqueue.web.service.RqueueSystemManagerService;
import com.github.sonus21.rqueue.web.service.RqueueUtilityService;
import com.github.sonus21.rqueue.web.service.RqueueViewControllerService;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class RqueueViewControllerServiceImpl
implements RqueueViewControllerService {
    private final RqueueConfig rqueueConfig;
    private final RqueueWebConfig rqueueWebConfig;
    private final RqueueQDetailService rqueueQDetailService;
    private final RqueueUtilityService rqueueUtilityService;
    private final RqueueSystemManagerService rqueueSystemManagerService;

    @Autowired
    public RqueueViewControllerServiceImpl(RqueueConfig rqueueConfig, RqueueWebConfig rqueueWebConfig, RqueueQDetailService rqueueQDetailService, RqueueUtilityService rqueueUtilityService, RqueueSystemManagerService rqueueSystemManagerService) {
        this.rqueueConfig = rqueueConfig;
        this.rqueueWebConfig = rqueueWebConfig;
        this.rqueueQDetailService = rqueueQDetailService;
        this.rqueueUtilityService = rqueueUtilityService;
        this.rqueueSystemManagerService = rqueueSystemManagerService;
    }

    private void addNavData(Model model, NavTab tab) {
        for (NavTab navTab : NavTab.values()) {
            String name = navTab.name().toLowerCase() + "Active";
            model.addAttribute(name, (Object)(tab == navTab ? 1 : 0));
        }
    }

    private void addBasicDetails(Model model, String xForwardedPrefix) {
        Pair<String, String> releaseAndVersion = this.rqueueUtilityService.getLatestVersion();
        model.addAttribute("releaseLink", (Object)releaseAndVersion.getFirst());
        model.addAttribute("latestVersion", (Object)releaseAndVersion.getSecond());
        model.addAttribute("time", (Object)OffsetDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        model.addAttribute("timeInMilli", (Object)System.currentTimeMillis());
        model.addAttribute("version", (Object)this.rqueueConfig.getLibVersion());
        model.addAttribute("urlPrefix", (Object)this.rqueueWebConfig.getUrlPrefix(xForwardedPrefix));
    }

    @Override
    public void index(Model model, String xForwardedPrefix) {
        this.addBasicDetails(model, xForwardedPrefix);
        this.addNavData(model, null);
        model.addAttribute("title", (Object)"Rqueue Dashboard");
        model.addAttribute("aggregatorTypes", Arrays.asList(AggregationType.values()));
        model.addAttribute("aggregatorDateCounter", (Object)this.rqueueUtilityService.aggregateDataCounter(AggregationType.DAILY));
        model.addAttribute("typeSelectors", ChartDataType.getActiveCharts());
    }

    @Override
    public void queues(Model model, String xForwardedPrefix) {
        this.addBasicDetails(model, xForwardedPrefix);
        this.addNavData(model, NavTab.QUEUES);
        model.addAttribute("title", (Object)"Queues");
        List<QueueConfig> queueConfigs = this.rqueueSystemManagerService.getSortedQueueConfigs();
        ArrayList<Map.Entry<String, List<Map.Entry<NavTab, RedisDataDetail>>>> queueNameConfigs = new ArrayList<Map.Entry<String, List<Map.Entry<NavTab, RedisDataDetail>>>>(this.rqueueQDetailService.getQueueDataStructureDetails(queueConfigs).entrySet());
        queueNameConfigs.sort(Map.Entry.comparingByKey());
        model.addAttribute("queues", queueConfigs);
        model.addAttribute("queueConfigs", queueNameConfigs);
    }

    @Override
    public void queueDetail(Model model, String xForwardedPrefix, String queueName) {
        QueueConfig queueConfig = this.rqueueSystemManagerService.getQueueConfig(queueName);
        List<NavTab> queueActions = this.rqueueQDetailService.getNavTabs(queueConfig);
        List<Map.Entry<NavTab, RedisDataDetail>> queueRedisDataDetail = this.rqueueQDetailService.getQueueDataStructureDetail(queueConfig);
        this.addBasicDetails(model, xForwardedPrefix);
        this.addNavData(model, NavTab.QUEUES);
        model.addAttribute("title", (Object)("Queue: " + queueName));
        model.addAttribute("queueName", (Object)queueName);
        model.addAttribute("aggregatorTypes", Arrays.asList(AggregationType.values()));
        model.addAttribute("aggregatorDateCounter", (Object)this.rqueueUtilityService.aggregateDataCounter(AggregationType.DAILY));
        model.addAttribute("typeSelectors", ChartDataType.getActiveCharts());
        model.addAttribute("queueActions", queueActions);
        model.addAttribute("queueRedisDataDetails", queueRedisDataDetail);
        model.addAttribute("config", (Object)queueConfig);
    }

    @Override
    public void running(Model model, String xForwardedPrefix) {
        this.addBasicDetails(model, xForwardedPrefix);
        this.addNavData(model, NavTab.RUNNING);
        model.addAttribute("title", (Object)"Running Tasks");
        List<List<Object>> l = this.rqueueQDetailService.getRunningTasks();
        model.addAttribute("tasks", l.subList(1, l.size()));
        model.addAttribute("header", l.get(0));
    }

    @Override
    public void scheduled(Model model, String xForwardedPrefix) {
        this.addBasicDetails(model, xForwardedPrefix);
        this.addNavData(model, NavTab.SCHEDULED);
        model.addAttribute("title", (Object)"Scheduled Tasks");
        List<List<Object>> l = this.rqueueQDetailService.getScheduledTasks();
        model.addAttribute("tasks", l.subList(1, l.size()));
        model.addAttribute("header", l.get(0));
    }

    @Override
    public void dead(Model model, String xForwardedPrefix) {
        this.addBasicDetails(model, xForwardedPrefix);
        this.addNavData(model, NavTab.DEAD);
        model.addAttribute("title", (Object)"Tasks moved to dead letter queue");
        List<List<Object>> l = this.rqueueQDetailService.getDeadLetterTasks();
        model.addAttribute("tasks", l.subList(1, l.size()));
        model.addAttribute("header", l.get(0));
    }

    @Override
    public void pending(Model model, String xForwardedPrefix) {
        this.addBasicDetails(model, xForwardedPrefix);
        this.addNavData(model, NavTab.PENDING);
        model.addAttribute("title", (Object)"Tasks waiting for execution");
        List<List<Object>> l = this.rqueueQDetailService.getWaitingTasks();
        model.addAttribute("tasks", l.subList(1, l.size()));
        model.addAttribute("header", l.get(0));
    }

    @Override
    public void utility(Model model, String xForwardedPrefix) {
        this.addBasicDetails(model, xForwardedPrefix);
        this.addNavData(model, NavTab.UTILITY);
        model.addAttribute("title", (Object)"Utility");
        model.addAttribute("supportedDataType", DataType.getEnabledDataTypes());
    }
}

