/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.MessageScheduler;
import com.github.sonus21.rqueue.listener.QueueDetail;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingMessageScheduler
extends MessageScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessingMessageScheduler.class);
    private Map<String, Long> queueNameToDelay;

    @Override
    protected void initialize() {
        super.initialize();
        List<QueueDetail> queueDetails = EndpointRegistry.getActiveQueueDetails();
        this.queueNameToDelay = new ConcurrentHashMap<String, Long>(queueDetails.size());
        for (QueueDetail queueDetail : queueDetails) {
            this.queueNameToDelay.put(queueDetail.getName(), queueDetail.getVisibilityTimeout());
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected String getChannelName(String queueName) {
        return EndpointRegistry.get(queueName).getProcessingQueueChannelName();
    }

    @Override
    protected String getZsetName(String queueName) {
        return EndpointRegistry.get(queueName).getProcessingQueueName();
    }

    @Override
    protected int getThreadPoolSize() {
        return this.rqueueSchedulerConfig.getProcessingMessageThreadPoolSize();
    }

    @Override
    protected boolean isProcessingQueue(String queueName) {
        return true;
    }

    @Override
    protected String getThreadNamePrefix() {
        return "processingMessageScheduler-";
    }

    @Override
    protected long getNextScheduleTime(String queueName, Long value) {
        long currentTime = System.currentTimeMillis();
        if (value == null) {
            long delay = this.queueNameToDelay.get(queueName);
            return currentTime + delay;
        }
        return Long.max(currentTime, value);
    }
}

