/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.MessageSweeper;
import com.github.sonus21.rqueue.core.support.RqueueMessageUtils;
import com.github.sonus21.rqueue.dao.RqueueStringDao;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.models.enums.MessageStatus;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.Validator;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

abstract class BaseMessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseMessageSender.class);
    protected final MessageHeaders messageHeaders;
    protected MessageConverter messageConverter;
    protected RqueueMessageTemplate messageTemplate;
    @Autowired
    protected RqueueStringDao rqueueStringDao;
    @Autowired
    protected RqueueConfig rqueueConfig;
    @Autowired
    protected RqueueMessageMetadataService rqueueMessageMetadataService;

    BaseMessageSender(RqueueMessageTemplate messageTemplate, MessageConverter messageConverter, MessageHeaders messageHeaders) {
        Assert.notNull((Object)messageTemplate, (String)"messageTemplate cannot be null");
        Assert.notNull((Object)messageConverter, (String)"messageConverter cannot be null");
        this.messageTemplate = messageTemplate;
        this.messageConverter = messageConverter;
        this.messageHeaders = messageHeaders;
    }

    protected void storeMessageMetadata(RqueueMessage rqueueMessage, Long delayInMillis) {
        Duration duration;
        MessageMetadata messageMetadata = new MessageMetadata(rqueueMessage, MessageStatus.ENQUEUED);
        if (delayInMillis != null) {
            duration = Duration.ofMillis(2L * delayInMillis);
            long minutes = duration.toMinutes();
            if (minutes < this.rqueueConfig.getMessageDurabilityInMinute()) {
                duration = Duration.ofMinutes(this.rqueueConfig.getMessageDurabilityInMinute());
            }
        } else {
            duration = Duration.ofMinutes(this.rqueueConfig.getMessageDurabilityInMinute());
        }
        this.rqueueMessageMetadataService.save(messageMetadata, duration);
    }

    private RqueueMessage constructMessage(String queueName, String messageId, Object message, Integer retryCount, Long delayInMilliSecs) {
        RqueueMessage rqueueMessage = RqueueMessageUtils.buildMessage(this.messageConverter, queueName, message, retryCount, delayInMilliSecs, this.messageHeaders);
        if (messageId != null) {
            rqueueMessage.setId(messageId);
        }
        return rqueueMessage;
    }

    protected void enqueue(QueueDetail queueDetail, RqueueMessage rqueueMessage, Long delayInMilliSecs) {
        if (delayInMilliSecs == null || delayInMilliSecs <= 100L) {
            this.messageTemplate.addMessage(queueDetail.getQueueName(), rqueueMessage);
        } else {
            this.messageTemplate.addMessageWithDelay(queueDetail.getDelayedQueueName(), queueDetail.getDelayedQueueChannelName(), rqueueMessage);
        }
    }

    protected String pushMessage(String queueName, String messageId, Object message, Integer retryCount, Long delayInMilliSecs) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        RqueueMessage rqueueMessage = this.constructMessage(queueName, messageId, message, retryCount, delayInMilliSecs);
        try {
            this.enqueue(queueDetail, rqueueMessage, delayInMilliSecs);
            this.storeMessageMetadata(rqueueMessage, delayInMilliSecs);
        }
        catch (Exception e) {
            log.error("Queue: {} Message {} could not be pushed {}", new Object[]{queueName, rqueueMessage, e});
            return null;
        }
        return rqueueMessage.getId();
    }

    protected String pushPeriodicMessage(String queueName, String messageId, Object message, long periodInMilliSeconds) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        RqueueMessage rqueueMessage = RqueueMessageUtils.buildPeriodicMessage(this.messageConverter, queueName, message, periodInMilliSeconds, this.messageHeaders);
        if (messageId != null) {
            rqueueMessage.setId(messageId);
        }
        try {
            this.enqueue(queueDetail, rqueueMessage, periodInMilliSeconds);
            this.storeMessageMetadata(rqueueMessage, periodInMilliSeconds);
        }
        catch (Exception e) {
            log.error("Queue: {} Message {} could not be pushed {}", new Object[]{queueName, rqueueMessage, e});
            return null;
        }
        return rqueueMessage.getId();
    }

    protected Object deleteAllMessages(QueueDetail queueDetail) {
        return MessageSweeper.getInstance(this.rqueueConfig, this.messageTemplate, this.rqueueMessageMetadataService).deleteMessage(MessageSweeper.MessageDeleteRequest.builder().queueDetail(queueDetail).build());
    }

    protected void registerQueueInternal(String queueName, String ... priorities) {
        Validator.validateQueue(queueName);
        Assert.notNull((Object)priorities, (String)"priorities cannot be null");
        HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        priorityMap.put("DEFAULT_PRIORITY", 1);
        for (String priority : priorities) {
            priorityMap.put(priority, 1);
        }
        QueueDetail queueDetail = QueueDetail.builder().name(queueName).active(false).queueName(this.rqueueConfig.getQueueName(queueName)).delayedQueueName(this.rqueueConfig.getDelayedQueueName(queueName)).delayedQueueChannelName(this.rqueueConfig.getDelayedQueueChannelName(queueName)).processingQueueName(this.rqueueConfig.getProcessingQueueName(queueName)).processingQueueChannelName(this.rqueueConfig.getProcessingQueueChannelName(queueName)).priority(priorityMap).build();
        EndpointRegistry.register(queueDetail);
        for (String priority : priorities) {
            String suffix = PriorityUtils.getSuffix(priority);
            queueDetail = QueueDetail.builder().name(queueName + suffix).active(false).queueName(this.rqueueConfig.getQueueName(queueName) + suffix).delayedQueueName(this.rqueueConfig.getDelayedQueueName(queueName) + suffix).delayedQueueChannelName(this.rqueueConfig.getDelayedQueueChannelName(queueName) + suffix).processingQueueName(this.rqueueConfig.getProcessingQueueName(queueName) + suffix).processingQueueChannelName(this.rqueueConfig.getProcessingQueueChannelName(queueName) + suffix).priority(Collections.singletonMap("DEFAULT_PRIORITY", 1)).build();
            EndpointRegistry.register(queueDetail);
        }
    }
}

