/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.utils.RetryableRunnable;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.slf4j.Logger;

abstract class MessageContainerBase
extends RetryableRunnable<Object> {
    protected final WeakReference<RqueueMessageListenerContainer> container;

    MessageContainerBase(Logger log, String groupName, RqueueMessageListenerContainer container) {
        this(log, groupName, new WeakReference<RqueueMessageListenerContainer>(container));
    }

    MessageContainerBase(Logger log, String groupName, WeakReference<RqueueMessageListenerContainer> container) {
        super(log, groupName);
        this.container = container;
    }

    protected RqueueMessageTemplate getRqueueMessageTemplate() {
        return Objects.requireNonNull((RqueueMessageListenerContainer)this.container.get()).getRqueueMessageTemplate();
    }

    boolean isQueueActive(String queueName) {
        return Objects.requireNonNull((RqueueMessageListenerContainer)this.container.get()).isQueueActive(queueName);
    }
}

