/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.core.Job;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.models.db.Execution;
import java.util.Collections;
import java.util.HashMap;
import org.springframework.messaging.MessageHeaders;

public final class RqueueMessageHeaders {
    public static final String DESTINATION = "destination";
    public static final String ID = "messageId";
    public static final String MESSAGE = "message";
    public static final String JOB = "job";
    public static final String EXECUTION = "execution";
    private static final MessageHeaders emptyMessageHeaders = new MessageHeaders(Collections.emptyMap());

    private RqueueMessageHeaders() {
    }

    public static MessageHeaders emptyMessageHeaders() {
        return emptyMessageHeaders;
    }

    public static MessageHeaders buildMessageHeaders(String destination, RqueueMessage rqueueMessage, Job job, Execution execution) {
        HashMap<String, Object> headers = new HashMap<String, Object>(5);
        headers.put(DESTINATION, destination);
        headers.put(ID, rqueueMessage.getId());
        headers.put(MESSAGE, rqueueMessage);
        if (job != null) {
            headers.put(JOB, job);
        }
        if (execution != null) {
            headers.put(EXECUTION, execution);
        }
        return new MessageHeaders(headers);
    }
}

