/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.dao.RqueueQStatsDao;
import com.github.sonus21.rqueue.exception.UnknownSwitchCase;
import com.github.sonus21.rqueue.models.MinMax;
import com.github.sonus21.rqueue.models.aggregator.TasksStat;
import com.github.sonus21.rqueue.models.db.JobRunTime;
import com.github.sonus21.rqueue.models.db.QueueStatistics;
import com.github.sonus21.rqueue.models.enums.AggregationType;
import com.github.sonus21.rqueue.models.enums.ChartDataType;
import com.github.sonus21.rqueue.models.request.ChartDataRequest;
import com.github.sonus21.rqueue.models.response.ChartDataResponse;
import com.github.sonus21.rqueue.utils.DateTimeUtils;
import com.github.sonus21.rqueue.utils.StringUtils;
import com.github.sonus21.rqueue.web.service.RqueueDashboardChartService;
import com.github.sonus21.rqueue.web.service.RqueueSystemManagerService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RqueueDashboardChartServiceImpl
implements RqueueDashboardChartService {
    private final RqueueQStatsDao rqueueQStatsDao;
    private final RqueueConfig rqueueConfig;
    private final RqueueWebConfig rqueueWebConfig;
    private final RqueueSystemManagerService rqueueSystemManagerService;

    @Autowired
    public RqueueDashboardChartServiceImpl(RqueueQStatsDao rqueueQStatsDao, RqueueConfig rqueueConfig, RqueueWebConfig rqueueWebConfig, RqueueSystemManagerService rqueueSystemManagerService) {
        this.rqueueQStatsDao = rqueueQStatsDao;
        this.rqueueConfig = rqueueConfig;
        this.rqueueWebConfig = rqueueWebConfig;
        this.rqueueSystemManagerService = rqueueSystemManagerService;
    }

    private List<ChartDataType> getChartDataType(List<ChartDataType> chartDataTypes) {
        if (!CollectionUtils.isEmpty(chartDataTypes)) {
            return chartDataTypes;
        }
        return Arrays.stream(ChartDataType.values()).filter(ChartDataType::isUserView).collect(Collectors.toList());
    }

    private void aggregateOneDataPoint(TasksStat stat, ChartDataType status, Object delta) {
        switch (status) {
            case SUCCESSFUL: {
                stat.success += ((Long)delta).longValue();
                break;
            }
            case MOVED_TO_DLQ: {
                stat.movedToDlq += ((Long)delta).longValue();
                break;
            }
            case DISCARDED: {
                stat.discarded += ((Long)delta).longValue();
                break;
            }
            case RETRIED: {
                stat.retried += ((Long)delta).longValue();
                break;
            }
            case EXECUTION: {
                JobRunTime jobRunTime = (JobRunTime)delta;
                stat.minExecution = Math.min(stat.minExecution, jobRunTime.getMin());
                stat.maxExecution = Math.max(stat.maxExecution, jobRunTime.getMax());
                stat.jobCount += jobRunTime.getJobCount();
                stat.totalExecutionTime += jobRunTime.getTotalExecutionTime();
                break;
            }
            default: {
                throw new UnknownSwitchCase(status.name());
            }
        }
    }

    private void aggregateOneQuant(IdGenerator idGenerator, Map<Integer, TasksStat> idToTasksStat, Map dateToObject, LocalDate today, MinMax<Integer> minMax, ChartDataType status) {
        for (Map.Entry mapEntry : dateToObject.entrySet()) {
            Map.Entry entry = mapEntry;
            String id = (String)entry.getKey();
            int key = idGenerator.getId(id, today);
            if (key > minMax.getMax()) {
                minMax.setMax(key);
            }
            if (key < minMax.getMin()) {
                minMax.setMin(key);
            }
            TasksStat stat = idToTasksStat.getOrDefault(key, new TasksStat());
            this.aggregateOneDataPoint(stat, status, entry.getValue());
            idToTasksStat.put(key, stat);
        }
    }

    private Map<Integer, TasksStat> aggregateData(IdGenerator idGenerator, List<QueueStatistics> queueStatisticsList, List<ChartDataType> chartDataTypeList, int maxRequired) {
        MinMax<Integer> jobRunTime = new MinMax<Integer>(Integer.MAX_VALUE, 0);
        LocalDate today = DateTimeUtils.today();
        HashMap<Integer, TasksStat> idToTasksStat = new HashMap<Integer, TasksStat>();
        for (QueueStatistics queueStatistics : queueStatisticsList) {
            block8: for (ChartDataType status : chartDataTypeList) {
                switch (status) {
                    case RETRIED: {
                        this.aggregateOneQuant(idGenerator, idToTasksStat, queueStatistics.getTasksRetried(), today, jobRunTime, status);
                        continue block8;
                    }
                    case DISCARDED: {
                        this.aggregateOneQuant(idGenerator, idToTasksStat, queueStatistics.getTasksDiscarded(), today, jobRunTime, status);
                        continue block8;
                    }
                    case MOVED_TO_DLQ: {
                        this.aggregateOneQuant(idGenerator, idToTasksStat, queueStatistics.getTasksMovedToDeadLetter(), today, jobRunTime, status);
                        continue block8;
                    }
                    case SUCCESSFUL: {
                        this.aggregateOneQuant(idGenerator, idToTasksStat, queueStatistics.getTasksSuccessful(), today, jobRunTime, status);
                        continue block8;
                    }
                    case EXECUTION: {
                        this.aggregateOneQuant(idGenerator, idToTasksStat, queueStatistics.getJobRunTime(), today, jobRunTime, status);
                        continue block8;
                    }
                }
                throw new UnknownSwitchCase(status.name());
            }
        }
        if (!idToTasksStat.isEmpty()) {
            for (int i = 0; i < jobRunTime.getMin(); ++i) {
                idToTasksStat.put(i, new TasksStat());
            }
        }
        if (jobRunTime.getMax() == 0 && idToTasksStat.isEmpty()) {
            idToTasksStat.put(0, new TasksStat());
        }
        for (int i = jobRunTime.getMax() + 1; i < maxRequired; ++i) {
            idToTasksStat.put(i, new TasksStat());
        }
        return idToTasksStat;
    }

    private List<Serializable> getHeader(String title, List<ChartDataType> chartDataTypeList) {
        LinkedList<Serializable> row = new LinkedList<Serializable>();
        row.add((Serializable)((Object)title));
        if (chartDataTypeList.size() == 1 && chartDataTypeList.get(0) == ChartDataType.EXECUTION) {
            row.add((Serializable)((Object)"Minimum execution time"));
            row.add((Serializable)((Object)"Maximum execution time"));
            row.add((Serializable)((Object)"Average execution time"));
        } else {
            for (ChartDataType status : chartDataTypeList) {
                row.add((Serializable)((Object)status.getDescription()));
            }
        }
        return row;
    }

    private List<Serializable> createRow(Integer id, TasksStat tasksStat, List<ChartDataType> chartDataTypeList) {
        LinkedList<Serializable> row = new LinkedList<Serializable>();
        row.add((Serializable)((Object)String.valueOf(id + 1)));
        block7: for (ChartDataType status : chartDataTypeList) {
            switch (status) {
                case RETRIED: {
                    row.add(Long.valueOf(tasksStat.retried));
                    continue block7;
                }
                case DISCARDED: {
                    row.add(Long.valueOf(tasksStat.discarded));
                    continue block7;
                }
                case MOVED_TO_DLQ: {
                    row.add(Long.valueOf(tasksStat.movedToDlq));
                    continue block7;
                }
                case SUCCESSFUL: {
                    row.add(Long.valueOf(tasksStat.success));
                    continue block7;
                }
                case EXECUTION: {
                    long minExecution = tasksStat.minExecution;
                    if (minExecution == Long.MAX_VALUE) {
                        minExecution = 0L;
                    }
                    row.add(Long.valueOf(minExecution));
                    row.add(Long.valueOf(tasksStat.maxExecution));
                    long average = 0L;
                    if (tasksStat.jobCount != 0L) {
                        average = tasksStat.totalExecutionTime / tasksStat.jobCount;
                    }
                    row.add(Long.valueOf(average));
                    continue block7;
                }
            }
            throw new UnknownSwitchCase(status.name());
        }
        return row;
    }

    private List<List<Serializable>> createChartData(String title, List<ChartDataType> chartDataTypeList, Map<Integer, TasksStat> idToTasksStat) {
        List entries = idToTasksStat.entrySet().stream().sorted((o1, o2) -> (Integer)o2.getKey() - (Integer)o1.getKey()).collect(Collectors.toList());
        ArrayList<List<Serializable>> rows = new ArrayList<List<Serializable>>();
        rows.add(this.getHeader(title, chartDataTypeList));
        for (Map.Entry entry : entries) {
            rows.add(this.createRow((Integer)entry.getKey(), (TasksStat)entry.getValue(), chartDataTypeList));
        }
        return rows;
    }

    private List<List<Serializable>> aggregateMonthly(List<QueueStatistics> queueStatisticsList, List<ChartDataType> chartDataTypeList) {
        Map<Integer, TasksStat> monthToChartDataType = this.aggregateData((date, today) -> (int)Math.floor((float)(today.toEpochDay() - LocalDate.parse(date).toEpochDay()) / 30.0f), queueStatisticsList, chartDataTypeList, this.getCount(30));
        return this.createChartData("Monthly", chartDataTypeList, monthToChartDataType);
    }

    private List<List<Serializable>> aggregateDaily(List<QueueStatistics> queueStatisticsList, List<ChartDataType> chartDataTypes) {
        Map<Integer, TasksStat> dayToChartDataType = this.aggregateData((date, today) -> (int)(today.toEpochDay() - LocalDate.parse(date).toEpochDay()), queueStatisticsList, chartDataTypes, this.getCount(1));
        return this.createChartData("Daily", chartDataTypes, dayToChartDataType);
    }

    private int getCount(int factor) {
        if (factor == 1) {
            return this.rqueueWebConfig.getHistoryDay();
        }
        return (int)Math.ceil((float)this.rqueueWebConfig.getHistoryDay() * 1.0f / (float)factor);
    }

    private List<List<Serializable>> aggregateWeekly(List<QueueStatistics> queueStatisticsList, List<ChartDataType> chartDataTypeList) {
        Map<Integer, TasksStat> weekToChartDataType = this.aggregateData((date, today) -> (int)Math.floor((float)(today.toEpochDay() - LocalDate.parse(date).toEpochDay()) / 7.0f), queueStatisticsList, chartDataTypeList, this.getCount(7));
        return this.createChartData("Weekly", chartDataTypeList, weekToChartDataType);
    }

    private List<List<Serializable>> getChartData(Collection<String> ids, AggregationType type, List<ChartDataType> chartDataTypes) {
        List<QueueStatistics> queueStatistics = this.rqueueQStatsDao.findAll(ids);
        if (queueStatistics == null) {
            queueStatistics = new ArrayList<QueueStatistics>();
        }
        switch (type) {
            case DAILY: {
                return this.aggregateDaily(queueStatistics, this.getChartDataType(chartDataTypes));
            }
            case WEEKLY: {
                return this.aggregateWeekly(queueStatistics, this.getChartDataType(chartDataTypes));
            }
            case MONTHLY: {
                return this.aggregateMonthly(queueStatistics, this.getChartDataType(chartDataTypes));
            }
        }
        throw new UnknownSwitchCase(type.name());
    }

    private ChartDataResponse getQueueStats(ChartDataRequest chartDataRequest) {
        Collection<String> ids = this.getQueueStatsId(chartDataRequest);
        List<List<Serializable>> rows = this.getChartData(ids, chartDataRequest.getAggregationType(), chartDataRequest.getDateTypes());
        ChartDataResponse response = new ChartDataResponse();
        response.setData(rows);
        response.setHTitle(chartDataRequest.getAggregationType().getDescription());
        response.setVTitle("N");
        if (StringUtils.isEmpty(chartDataRequest.getQueue())) {
            response.setTitle("Task Status");
        } else {
            response.setTitle("Queue[" + chartDataRequest.getQueue() + "]");
        }
        return response;
    }

    private Collection<String> getQueueStatsId(ChartDataRequest chartDataRequest) {
        Collection<Object> ids = Collections.emptyList();
        if (!StringUtils.isEmpty(chartDataRequest.getQueue())) {
            ids = Collections.singleton(this.rqueueConfig.getQueueStatisticsKey(chartDataRequest.getQueue()));
        } else {
            List<String> queues = this.rqueueSystemManagerService.getQueues();
            if (!CollectionUtils.isEmpty(queues)) {
                ids = queues.stream().map(this.rqueueConfig::getQueueStatisticsKey).collect(Collectors.toList());
            }
        }
        return ids;
    }

    private ChartDataResponse getQueueLatency(ChartDataRequest chartDataRequest) {
        Collection<String> ids = this.getQueueStatsId(chartDataRequest);
        List<List<Serializable>> rows = this.getChartData(ids, chartDataRequest.getAggregationType(), Collections.singletonList(ChartDataType.EXECUTION));
        ChartDataResponse response = new ChartDataResponse();
        response.setData(rows);
        response.setHTitle(chartDataRequest.getAggregationType().getDescription());
        response.setVTitle("Milliseconds");
        if (!StringUtils.isEmpty(chartDataRequest.getQueue())) {
            response.setTitle("Latency [" + chartDataRequest.getQueue() + "]");
        } else {
            response.setTitle("Overall Latency");
        }
        return response;
    }

    @Override
    public ChartDataResponse getDashboardChartData(ChartDataRequest chartDataRequest) {
        ChartDataResponse chartDataResponse = chartDataRequest.validate();
        if (chartDataResponse != null) {
            return chartDataResponse;
        }
        switch (chartDataRequest.getType()) {
            case LATENCY: {
                return this.getQueueLatency(chartDataRequest);
            }
            case STATS: {
                return this.getQueueStats(chartDataRequest);
            }
        }
        throw new UnknownSwitchCase(chartDataRequest.getType().name());
    }

    private static interface IdGenerator {
        public int getId(String var1, LocalDate var2);
    }
}

