/*
 *  Copyright 2021 Sonu Kumar
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         https://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and limitations under the License.
 *
 */

package com.github.sonus21.rqueue.core.middleware;

import com.github.sonus21.rqueue.core.Job;
import com.github.sonus21.rqueue.models.enums.JobStatus;
import java.util.concurrent.Callable;

public interface RateLimiterMiddleware extends TimeProviderMiddleware {

  boolean isThrottled(Job job);

  @Override
  default void handle(Job job, Callable<Void> callable) throws Exception {
    if (isThrottled(job)) {
      job.release(JobStatus.FAILED, "Throttled", releaseIn(job));
    } else {
      callable.call();
    }
  }
}
