/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.config;

import com.github.sonus21.rqueue.core.DefaultRqueueMessageConverter;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.RqueueMessageTemplateImpl;
import com.github.sonus21.rqueue.core.middleware.Middleware;
import com.github.sonus21.rqueue.core.support.MessageProcessor;
import com.github.sonus21.rqueue.listener.RqueueMessageHandler;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.models.enums.PriorityMode;
import com.github.sonus21.rqueue.utils.backoff.TaskExecutionBackOff;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SimpleRqueueListenerContainerFactory {
    private AsyncTaskExecutor taskExecutor;
    private boolean autoStartup = true;
    private RedisConnectionFactory redisConnectionFactory;
    private ReactiveRedisConnectionFactory reactiveRedisConnectionFactory;
    private RqueueMessageHandler rqueueMessageHandler;
    private MessageConverter messageConverter = new DefaultRqueueMessageConverter();
    private long pollingInterval = 200L;
    private long backOffTime = 5000L;
    private Integer maxNumWorkers;
    private MessageProcessor preExecutionMessageProcessor;
    private MessageProcessor discardMessageProcessor;
    private MessageProcessor deadLetterQueueMessageProcessor;
    private MessageProcessor manualDeletionMessageProcessor;
    private MessageProcessor postExecutionMessageProcessor;
    private RqueueMessageTemplate rqueueMessageTemplate;
    private final List<Middleware> middlewares = new LinkedList<Middleware>();
    private MessageHeaders messageHeaders;
    private PriorityMode priorityMode = PriorityMode.WEIGHTED;
    private boolean inspectAllBean = true;
    private TaskExecutionBackOff taskExecutionBackOff;

    public AsyncTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"taskExecutor cannot be null");
        this.taskExecutor = taskExecutor;
    }

    public Boolean getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public RqueueMessageHandler getRqueueMessageHandler() {
        if (this.rqueueMessageHandler == null) {
            this.rqueueMessageHandler = new RqueueMessageHandler(this.getMessageConverter(), this.inspectAllBean);
        }
        return this.rqueueMessageHandler;
    }

    public void setRqueueMessageHandler(RqueueMessageHandler rqueueMessageHandler) {
        Assert.notNull((Object)((Object)rqueueMessageHandler), (String)"rqueueMessageHandler must not be null");
        this.rqueueMessageHandler = rqueueMessageHandler;
    }

    public long getBackOffTime() {
        return this.backOffTime;
    }

    public void setBackOffTime(long backOffTime) {
        this.backOffTime = backOffTime;
    }

    public Integer getMaxNumWorkers() {
        return this.maxNumWorkers;
    }

    public void setMaxNumWorkers(int maxNumWorkers) {
        if (maxNumWorkers < 1) {
            throw new IllegalArgumentException("At least one worker");
        }
        this.maxNumWorkers = maxNumWorkers;
    }

    @Deprecated
    public List<MessageConverter> getMessageConverters() {
        return Collections.singletonList(this.getMessageConverter());
    }

    @Deprecated
    public void setMessageConverters(List<MessageConverter> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"messageConverters must not be empty");
        if (messageConverters.size() == 1) {
            this.setMessageConverter(messageConverters.get(0));
        } else {
            this.setMessageConverter((MessageConverter)new CompositeMessageConverter(messageConverters));
        }
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"message converter must not be null");
        this.messageConverter = messageConverter;
    }

    public RedisConnectionFactory getRedisConnectionFactory() {
        return this.redisConnectionFactory;
    }

    public void setRedisConnectionFactory(RedisConnectionFactory redisConnectionFactory) {
        Assert.notNull((Object)redisConnectionFactory, (String)"redisConnectionFactory must not be null");
        this.redisConnectionFactory = redisConnectionFactory;
    }

    public RqueueMessageTemplate getRqueueMessageTemplate() {
        return this.rqueueMessageTemplate;
    }

    public void setRqueueMessageTemplate(RqueueMessageTemplate messageTemplate) {
        Assert.notNull((Object)messageTemplate, (String)"messageTemplate must not be null");
        this.rqueueMessageTemplate = messageTemplate;
    }

    public RqueueMessageListenerContainer createMessageListenerContainer() {
        Assert.notNull((Object)((Object)this.getRqueueMessageHandler()), (String)"rqueueMessageHandler must not be null");
        Assert.notNull((Object)this.redisConnectionFactory, (String)"redisConnectionFactory must not be null");
        if (this.rqueueMessageTemplate == null) {
            this.rqueueMessageTemplate = new RqueueMessageTemplateImpl(this.getRedisConnectionFactory(), this.getReactiveRedisConnectionFactory());
        }
        RqueueMessageListenerContainer messageListenerContainer = new RqueueMessageListenerContainer(this.getRqueueMessageHandler(), this.rqueueMessageTemplate);
        messageListenerContainer.setAutoStartup(this.autoStartup);
        if (this.taskExecutor != null) {
            messageListenerContainer.setTaskExecutor(this.taskExecutor);
        }
        if (this.maxNumWorkers != null) {
            messageListenerContainer.setMaxNumWorkers(this.maxNumWorkers);
        }
        messageListenerContainer.setBackOffTime(this.getBackOffTime());
        messageListenerContainer.setPollingInterval(this.getPollingInterval());
        if (this.postExecutionMessageProcessor != null) {
            messageListenerContainer.setPostExecutionMessageProcessor(this.getPostExecutionMessageProcessor());
        }
        if (this.deadLetterQueueMessageProcessor != null) {
            messageListenerContainer.setDeadLetterQueueMessageProcessor(this.getDeadLetterQueueMessageProcessor());
        }
        if (this.manualDeletionMessageProcessor != null) {
            messageListenerContainer.setManualDeletionMessageProcessor(this.getManualDeletionMessageProcessor());
        }
        if (this.discardMessageProcessor != null) {
            messageListenerContainer.setDiscardMessageProcessor(this.discardMessageProcessor);
        }
        if (this.getPreExecutionMessageProcessor() != null) {
            messageListenerContainer.setPreExecutionMessageProcessor(this.preExecutionMessageProcessor);
        }
        if (this.getTaskExecutionBackOff() != null) {
            messageListenerContainer.setTaskExecutionBackOff(this.getTaskExecutionBackOff());
        }
        if (this.getPriorityMode() != null) {
            messageListenerContainer.setPriorityMode(this.getPriorityMode());
        }
        if (!CollectionUtils.isEmpty(this.getMiddlewares())) {
            messageListenerContainer.setMiddlewares(this.getMiddlewares());
        }
        return messageListenerContainer;
    }

    public MessageProcessor getDiscardMessageProcessor() {
        return this.discardMessageProcessor;
    }

    public void setDiscardMessageProcessor(MessageProcessor discardMessageProcessor) {
        Assert.notNull((Object)discardMessageProcessor, (String)"discardMessageProcessor cannot be null");
        this.discardMessageProcessor = discardMessageProcessor;
    }

    public MessageProcessor getDeadLetterQueueMessageProcessor() {
        return this.deadLetterQueueMessageProcessor;
    }

    public void setDeadLetterQueueMessageProcessor(MessageProcessor deadLetterQueueMessageProcessor) {
        Assert.notNull((Object)deadLetterQueueMessageProcessor, (String)"deadLetterQueueMessageProcessor cannot be null");
        this.deadLetterQueueMessageProcessor = deadLetterQueueMessageProcessor;
    }

    public MessageProcessor getManualDeletionMessageProcessor() {
        return this.manualDeletionMessageProcessor;
    }

    public void setManualDeletionMessageProcessor(MessageProcessor manualDeletionMessageProcessor) {
        Assert.notNull((Object)manualDeletionMessageProcessor, (String)"manualDeletionMessageProcessor cannot be null");
        this.manualDeletionMessageProcessor = manualDeletionMessageProcessor;
    }

    public MessageProcessor getPostExecutionMessageProcessor() {
        return this.postExecutionMessageProcessor;
    }

    public void setPostExecutionMessageProcessor(MessageProcessor postExecutionMessageProcessor) {
        Assert.notNull((Object)postExecutionMessageProcessor, (String)"postExecutionMessageProcessor cannot be null");
        this.postExecutionMessageProcessor = postExecutionMessageProcessor;
    }

    public MessageProcessor getPreExecutionMessageProcessor() {
        return this.preExecutionMessageProcessor;
    }

    public void setPreExecutionMessageProcessor(MessageProcessor preExecutionMessageProcessor) {
        Assert.notNull((Object)preExecutionMessageProcessor, (String)"preMessageProcessor cannot be null");
        this.preExecutionMessageProcessor = preExecutionMessageProcessor;
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public TaskExecutionBackOff getTaskExecutionBackOff() {
        return this.taskExecutionBackOff;
    }

    public void setTaskExecutionBackOff(TaskExecutionBackOff taskExecutionBackOff) {
        Assert.notNull((Object)taskExecutionBackOff, (String)"taskExecutionBackOff cannot be null");
        this.taskExecutionBackOff = taskExecutionBackOff;
    }

    public PriorityMode getPriorityMode() {
        return this.priorityMode;
    }

    public void setPriorityMode(PriorityMode priorityMode) {
        this.priorityMode = priorityMode;
    }

    public MessageHeaders getMessageHeaders() {
        return this.messageHeaders;
    }

    public void setMessageHeaders(MessageHeaders messageHeaders) {
        Assert.notEmpty((Map)messageHeaders, (String)"messageHeaders can not be empty");
        this.messageHeaders = messageHeaders;
    }

    public void setInspectAllBean(boolean inspectAllBean) {
        this.inspectAllBean = inspectAllBean;
    }

    public List<Middleware> getMiddlewares() {
        return this.middlewares;
    }

    public void setMiddlewares(List<Middleware> middlewares) {
        Assert.notEmpty(middlewares, (String)"middlewares cannot be empty");
        this.middlewares.addAll(middlewares);
    }

    public void useMiddleware(Middleware middleware) {
        Assert.notNull(this.middlewares, (String)"middlewares cannot be null");
        this.middlewares.add(middleware);
    }

    public ReactiveRedisConnectionFactory getReactiveRedisConnectionFactory() {
        return this.reactiveRedisConnectionFactory;
    }

    public void setReactiveRedisConnectionFactory(ReactiveRedisConnectionFactory reactiveRedisConnectionFactory) {
        Assert.notNull((Object)reactiveRedisConnectionFactory, (String)"reactiveRedisConnectionFactory can not be null");
        this.reactiveRedisConnectionFactory = reactiveRedisConnectionFactory;
    }
}

