/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.ReactiveRqueueMessageEnqueuer;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.BaseMessageSender;
import com.github.sonus21.rqueue.core.support.RqueueMessageUtils;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.Validator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveRqueueMessageEnqueuerImpl
extends BaseMessageSender
implements ReactiveRqueueMessageEnqueuer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactiveRqueueMessageEnqueuerImpl.class);

    public ReactiveRqueueMessageEnqueuerImpl(RqueueMessageTemplate messageTemplate, MessageConverter messageConverter, MessageHeaders messageHeaders) {
        super(messageTemplate, messageConverter, messageHeaders);
    }

    private <T> Mono<T> pushReactiveMessage(MessageBuilder builder, String queueName, String messageId, Object message, Integer retryCount, Long delayInMilliSecs, MonoConverterGenerator<T> monoConverterGenerator) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        RqueueMessage rqueueMessage = builder.build(this.messageConverter, queueName, messageId, message, retryCount, delayInMilliSecs, this.messageHeaders);
        MonoConverter<T> monoConverter = monoConverterGenerator.create(rqueueMessage);
        try {
            Object o1 = this.enqueue(queueDetail, rqueueMessage, delayInMilliSecs, true);
            Mono storeMessageResult = (Mono)this.storeMessageMetadata(rqueueMessage, delayInMilliSecs, true);
            Mono longMono = o1 instanceof Flux ? ((Flux)o1).elementAt(0) : (Mono)o1;
            return longMono.zipWith(storeMessageResult, monoConverter::call);
        }
        catch (Exception e) {
            log.error("Queue: {} Message {} could not be pushed {}", new Object[]{queueName, rqueueMessage, e});
            return Mono.error((Throwable)e);
        }
    }

    private Mono<String> pushReactiveMessage(String queueName, Object message, Integer retryCount, Long delayInMilliSecs) {
        return this.pushReactiveMessage(RqueueMessageUtils::buildMessage, queueName, null, message, retryCount, delayInMilliSecs, new StrMonoConverterGenerator());
    }

    private Mono<Boolean> pushReactiveWithMessageId(String queueName, String messageId, Object message, Integer retryCount, Long delayInMilliSecs) {
        return this.pushReactiveMessage(RqueueMessageUtils::buildMessage, queueName, messageId, message, retryCount, delayInMilliSecs, new BooleanMonoConverterGenerator());
    }

    private Mono<String> pushReactivePeriodicMessage(String queueName, Object message, long periodInMilliSeconds) {
        return this.pushReactiveMessage(RqueueMessageUtils::buildPeriodicMessage, queueName, null, message, null, periodInMilliSeconds, new StrMonoConverterGenerator());
    }

    private Mono<Boolean> pushReactivePeriodicMessageWithMessageId(String queueName, String messageId, Object message, long periodInMilliSeconds) {
        return this.pushReactiveMessage(RqueueMessageUtils::buildPeriodicMessage, queueName, messageId, message, null, periodInMilliSeconds, new BooleanMonoConverterGenerator());
    }

    @Override
    public Mono<String> enqueue(String queueName, Object message) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        return this.pushReactiveMessage(queueName, message, null, null);
    }

    @Override
    public Mono<Boolean> enqueue(String queueName, String messageId, Object message) {
        Validator.validateQueue(queueName);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        return this.pushReactiveWithMessageId(queueName, messageId, message, null, null);
    }

    @Override
    public Mono<Boolean> enqueueUnique(String queueName, String messageId, Object message) {
        Validator.validateQueue(queueName);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        return this.pushReactiveWithMessageId(queueName, messageId, message, null, null);
    }

    @Override
    public Mono<String> enqueueWithRetry(String queueName, Object message, int retryCount) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        return this.pushReactiveMessage(queueName, message, retryCount, null);
    }

    @Override
    public Mono<Boolean> enqueueWithRetry(String queueName, String messageId, Object message, int retryCount) {
        Validator.validateQueue(queueName);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        return this.pushReactiveWithMessageId(queueName, messageId, message, retryCount, null);
    }

    @Override
    public Mono<String> enqueueWithPriority(String queueName, String priority, Object message) {
        Validator.validateQueue(queueName);
        Validator.validatePriority(priority);
        Validator.validateMessage(message);
        return this.pushReactiveMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), message, null, null);
    }

    @Override
    public Mono<Boolean> enqueueWithPriority(String queueName, String priority, String messageId, Object message) {
        Validator.validateQueue(queueName);
        Validator.validatePriority(priority);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        return this.pushReactiveWithMessageId(PriorityUtils.getQueueNameForPriority(queueName, priority), messageId, message, null, null);
    }

    @Override
    public Mono<String> enqueueIn(String queueName, Object message, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushReactiveMessage(queueName, message, null, delayInMilliSecs);
    }

    @Override
    public Mono<Boolean> enqueueIn(String queueName, String messageId, Object message, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushReactiveWithMessageId(queueName, messageId, message, null, delayInMilliSecs);
    }

    @Override
    public Mono<Boolean> enqueueUniqueIn(String queueName, String messageId, Object message, long delayInMillisecond) {
        Validator.validateQueue(queueName);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        Validator.validateDelay(delayInMillisecond);
        return this.pushReactiveWithMessageId(queueName, messageId, message, null, delayInMillisecond);
    }

    @Override
    public Mono<String> enqueueInWithRetry(String queueName, Object message, int retryCount, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushReactiveMessage(queueName, message, retryCount, delayInMilliSecs);
    }

    @Override
    public Mono<Boolean> enqueueInWithRetry(String queueName, String messageId, Object message, int retryCount, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        Validator.validateDelay(retryCount);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushReactiveWithMessageId(queueName, messageId, message, retryCount, delayInMilliSecs);
    }

    @Override
    public Mono<String> enqueuePeriodic(String queueName, Object message, long periodInMilliSeconds) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validatePeriod(periodInMilliSeconds);
        return this.pushReactivePeriodicMessage(queueName, message, periodInMilliSeconds);
    }

    @Override
    public Mono<Boolean> enqueuePeriodic(String queueName, String messageId, Object message, long periodInMilliSeconds) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateMessageId(messageId);
        Validator.validatePeriod(periodInMilliSeconds);
        return this.pushReactivePeriodicMessageWithMessageId(queueName, messageId, message, periodInMilliSeconds);
    }

    private static class BooleanMonoConverterGenerator
    implements MonoConverterGenerator<Boolean> {
        private BooleanMonoConverterGenerator() {
        }

        @Override
        public MonoConverter<Boolean> create(RqueueMessage rqueueMessage) {
            return new BoolMonoConverter(rqueueMessage);
        }
    }

    private static class StrMonoConverterGenerator
    implements MonoConverterGenerator<String> {
        private StrMonoConverterGenerator() {
        }

        @Override
        public MonoConverter<String> create(RqueueMessage rqueueMessage) {
            return new StrMonoConverter(rqueueMessage);
        }
    }

    private static class BoolMonoConverter
    implements MonoConverter<Boolean> {
        private BoolMonoConverter(RqueueMessage message) {
        }

        @Override
        public Boolean call(Long a, Boolean b) {
            return Boolean.TRUE;
        }
    }

    private static class StrMonoConverter
    implements MonoConverter<String> {
        private final RqueueMessage message;

        private StrMonoConverter(RqueueMessage message) {
            this.message = message;
        }

        @Override
        public String call(Long a, Boolean b) {
            return this.message.getId();
        }
    }

    private static interface MonoConverterGenerator<T> {
        public MonoConverter<T> create(RqueueMessage var1);
    }

    private static interface MessageBuilder {
        public RqueueMessage build(MessageConverter var1, String var2, String var3, Object var4, Integer var5, Long var6, MessageHeaders var7);
    }

    private static interface MonoConverter<T> {
        public T call(Long var1, Boolean var2);
    }
}

