/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.core.RqueueMessageEnqueuer;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.BaseMessageSender;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.Validator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;

public class RqueueMessageEnqueuerImpl
extends BaseMessageSender
implements RqueueMessageEnqueuer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageEnqueuerImpl.class);

    public RqueueMessageEnqueuerImpl(RqueueMessageTemplate messageTemplate, MessageConverter messageConverter, MessageHeaders messageHeaders) {
        super(messageTemplate, messageConverter, messageHeaders);
    }

    @Override
    public String enqueue(String queueName, Object message) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        return this.pushMessage(queueName, null, message, null, null);
    }

    @Override
    public boolean enqueue(String queueName, String messageId, Object message) {
        Validator.validateQueue(queueName);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        return this.pushMessage(queueName, messageId, message, null, null) != null;
    }

    @Override
    public boolean enqueueUnique(String queueName, String messageId, Object message) {
        return this.enqueue(queueName, messageId, message);
    }

    @Override
    public String enqueueWithRetry(String queueName, Object message, int retryCount) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        return this.pushMessage(queueName, null, message, retryCount, null);
    }

    @Override
    public boolean enqueueWithRetry(String queueName, String messageId, Object message, int retryCount) {
        Validator.validateQueue(queueName);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        return this.pushMessage(queueName, messageId, message, retryCount, null) != null;
    }

    @Override
    public String enqueueWithPriority(String queueName, String priority, Object message) {
        Validator.validateQueue(queueName);
        Validator.validatePriority(priority);
        Validator.validateMessage(message);
        return this.pushMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), null, message, null, null);
    }

    @Override
    public boolean enqueueWithPriority(String queueName, String priority, String messageId, Object message) {
        Validator.validateQueue(queueName);
        Validator.validatePriority(priority);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        return this.pushMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), messageId, message, null, null) != null;
    }

    @Override
    public String enqueueIn(String queueName, Object message, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, null, message, null, delayInMilliSecs);
    }

    @Override
    public boolean enqueueIn(String queueName, String messageId, Object message, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, messageId, message, null, delayInMilliSecs) != null;
    }

    @Override
    public boolean enqueueUniqueIn(String queueName, String messageId, Object message, long delayInMillisecond) {
        return this.enqueueIn(queueName, messageId, message, delayInMillisecond);
    }

    @Override
    public String enqueueInWithRetry(String queueName, Object message, int retryCount, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, null, message, retryCount, delayInMilliSecs);
    }

    @Override
    public boolean enqueueInWithRetry(String queueName, String messageId, Object message, int retryCount, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessageId(messageId);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, messageId, message, retryCount, delayInMilliSecs) != null;
    }

    @Override
    public String enqueuePeriodic(String queueName, Object message, long period) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validatePeriod(period);
        return this.pushPeriodicMessage(queueName, null, message, period);
    }

    @Override
    public boolean enqueuePeriodic(String queueName, String messageId, Object message, long period) {
        Validator.validateMessageId(messageId);
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validatePeriod(period);
        return this.pushPeriodicMessage(queueName, messageId, message, period) != null;
    }
}

