/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.exception.TimedOutException;
import java.util.function.BooleanSupplier;

public final class TimeoutUtils {
    public static final long EXECUTION_TIME = 10000L;
    public static final long SLEEP_TIME = 100L;

    private TimeoutUtils() {
    }

    public static void waitFor(BooleanSupplier callback, long waitTimeInMilliSeconds, String description) throws TimedOutException {
        TimeoutUtils.waitFor(callback, waitTimeInMilliSeconds, description, () -> {});
    }

    public static void waitFor(BooleanSupplier callback, String description) throws TimedOutException {
        TimeoutUtils.waitFor(callback, 10000L, description);
    }

    public static void waitFor(BooleanSupplier callback, String description, Runnable postmortem) throws TimedOutException {
        TimeoutUtils.waitFor(callback, 10000L, description, postmortem);
    }

    public static void waitFor(BooleanSupplier callback, long waitTimeInMilliSeconds, String description, Runnable postmortem) throws TimedOutException {
        long endTime = System.currentTimeMillis() + waitTimeInMilliSeconds;
        do {
            if (Boolean.TRUE.equals(callback.getAsBoolean())) {
                return;
            }
            TimeoutUtils.sleep(100L);
        } while (System.currentTimeMillis() < endTime);
        try {
            postmortem.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new TimedOutException("Timed out waiting for " + description);
    }

    public static void sleep(long time) {
        TimeoutUtils.sleepLog(time, true);
    }

    public static void sleepLog(long time, boolean log) {
        block2: {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (!log) break block2;
                e.printStackTrace();
            }
        }
    }
}

