/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils.backoff;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.utils.backoff.TaskExecutionBackOff;

public class FixedTaskExecutionBackOff
implements TaskExecutionBackOff {
    public static final long DEFAULT_INTERVAL = 5000L;
    private long interval = 5000L;
    private int maxRetries = Integer.MAX_VALUE;

    public FixedTaskExecutionBackOff() {
    }

    public FixedTaskExecutionBackOff(long interval, int maxRetries) {
        this.checkInterval(interval);
        this.checkMaxRetries(maxRetries);
        this.interval = interval;
        this.maxRetries = maxRetries;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.checkInterval(interval);
        this.interval = interval;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.checkMaxRetries(maxRetries);
        this.maxRetries = maxRetries;
    }

    @Override
    public long nextBackOff(Object message, RqueueMessage rqueueMessage, int failureCount) {
        if (failureCount >= this.getMaxRetries(message, rqueueMessage, failureCount)) {
            return -1L;
        }
        return this.getInterval(message, rqueueMessage, failureCount);
    }

    protected int getMaxRetries(Object message, RqueueMessage rqueueMessage, int failureCount) {
        return this.getMaxRetries();
    }

    protected long getInterval(Object message, RqueueMessage rqueueMessage, int failureCount) {
        return this.getInterval();
    }

    private void checkInterval(long interval) {
        if (interval <= 0L) {
            throw new IllegalArgumentException("interval must be > 0");
        }
    }

    private void checkMaxRetries(int maxRetries) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries must be > 0");
        }
    }

    public boolean equals(Object other) {
        if (other instanceof FixedTaskExecutionBackOff) {
            return ((FixedTaskExecutionBackOff)other).getInterval() == this.getInterval() && ((FixedTaskExecutionBackOff)other).getMaxRetries() == this.getMaxRetries();
        }
        return false;
    }
}

