/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.controller;

import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.exception.ProcessingException;
import com.github.sonus21.rqueue.models.request.ChartDataRequest;
import com.github.sonus21.rqueue.models.request.DataDeleteRequest;
import com.github.sonus21.rqueue.models.request.DataTypeRequest;
import com.github.sonus21.rqueue.models.request.DateViewRequest;
import com.github.sonus21.rqueue.models.request.MessageDeleteRequest;
import com.github.sonus21.rqueue.models.request.MessageMoveRequest;
import com.github.sonus21.rqueue.models.request.PauseUnpauseQueueRequest;
import com.github.sonus21.rqueue.models.request.QueueExploreRequest;
import com.github.sonus21.rqueue.models.response.BaseResponse;
import com.github.sonus21.rqueue.models.response.BooleanResponse;
import com.github.sonus21.rqueue.models.response.ChartDataResponse;
import com.github.sonus21.rqueue.models.response.DataViewResponse;
import com.github.sonus21.rqueue.models.response.MessageMoveResponse;
import com.github.sonus21.rqueue.models.response.StringResponse;
import com.github.sonus21.rqueue.utils.ReactiveDisabled;
import com.github.sonus21.rqueue.web.service.RqueueDashboardChartService;
import com.github.sonus21.rqueue.web.service.RqueueJobService;
import com.github.sonus21.rqueue.web.service.RqueueQDetailService;
import com.github.sonus21.rqueue.web.service.RqueueSystemManagerService;
import com.github.sonus21.rqueue.web.service.RqueueUtilityService;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rqueue/api/v1"})
@Conditional(value={ReactiveDisabled.class})
public class RqueueRestController {
    private final RqueueDashboardChartService rqueueDashboardChartService;
    private final RqueueQDetailService rqueueQDetailService;
    private final RqueueUtilityService rqueueUtilityService;
    private final RqueueSystemManagerService rqueueQManagerService;
    private final RqueueWebConfig rqueueWebConfig;
    private final RqueueJobService rqueueJobService;

    @Autowired
    public RqueueRestController(RqueueDashboardChartService rqueueDashboardChartService, RqueueQDetailService rqueueQDetailService, RqueueUtilityService rqueueUtilityService, RqueueSystemManagerService rqueueQManagerService, RqueueWebConfig rqueueWebConfig, RqueueJobService rqueueJobService) {
        this.rqueueDashboardChartService = rqueueDashboardChartService;
        this.rqueueQDetailService = rqueueQDetailService;
        this.rqueueUtilityService = rqueueUtilityService;
        this.rqueueQManagerService = rqueueQManagerService;
        this.rqueueWebConfig = rqueueWebConfig;
        this.rqueueJobService = rqueueJobService;
    }

    @PostMapping(value={"chart"})
    @ResponseBody
    public ChartDataResponse getDashboardData(@RequestBody @Valid ChartDataRequest chartDataRequest, HttpServletResponse response) {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        return this.rqueueDashboardChartService.getDashboardChartData(chartDataRequest);
    }

    @GetMapping(value={"jobs"})
    @ResponseBody
    public DataViewResponse getJobs(@RequestParam(name="message-id") @NotEmpty String messageId, HttpServletResponse response) throws ProcessingException {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        return this.rqueueJobService.getJobs(messageId);
    }

    @PostMapping(value={"queue-data"})
    @ResponseBody
    public DataViewResponse exploreQueue(@Valid @RequestBody QueueExploreRequest request, HttpServletResponse response) {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        return this.rqueueQDetailService.getExplorePageData(request.getSrc(), request.getName(), request.getType(), request.getPageNumber(), request.getItemPerPage());
    }

    @PostMapping(value={"view-data"})
    @ResponseBody
    public DataViewResponse viewData(@RequestBody @Valid DateViewRequest request, HttpServletResponse response) {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        return this.rqueueQDetailService.viewData(request.getName(), request.getType(), request.getKey(), request.getPageNumber(), request.getItemPerPage());
    }

    @PostMapping(value={"delete-message"})
    @ResponseBody
    public BooleanResponse deleteMessage(@Valid @RequestBody MessageDeleteRequest request, HttpServletResponse response) {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        return this.rqueueUtilityService.deleteMessage(request.getQueueName(), request.getMessageId());
    }

    @PostMapping(value={"delete-queue"})
    @ResponseBody
    public BaseResponse deleteQueue(@Valid @RequestBody DataTypeRequest request, HttpServletResponse response) {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        return this.rqueueQManagerService.deleteQueue(request.getName());
    }

    @PostMapping(value={"delete-queue-part"})
    @ResponseBody
    public BooleanResponse deleteAll(@RequestBody @Valid DataDeleteRequest request, HttpServletResponse response) {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        return this.rqueueUtilityService.makeEmpty(request.getQueueName(), request.getDatasetName());
    }

    @PostMapping(value={"data-type"})
    @ResponseBody
    public StringResponse dataType(@RequestBody @Valid DataTypeRequest request, HttpServletResponse response) {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        return this.rqueueUtilityService.getDataType(request.getName());
    }

    @PostMapping(value={"move-data"})
    @ResponseBody
    public MessageMoveResponse dataType(@RequestBody @Valid MessageMoveRequest request, HttpServletResponse response) {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        return this.rqueueUtilityService.moveMessage(request);
    }

    @PostMapping(value={"pause-unpause-queue"})
    @ResponseBody
    public BaseResponse pauseUnpauseQueue(@RequestBody @Valid PauseUnpauseQueueRequest request, HttpServletResponse response) {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        return this.rqueueUtilityService.pauseUnpauseQueue(request);
    }
}

