/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.controller;

import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.utils.ReactiveDisabled;
import com.github.sonus21.rqueue.web.service.RqueueViewControllerService;
import com.mitchellbosecke.pebble.spring.servlet.PebbleViewResolver;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.View;

@Controller
@RequestMapping(value={"rqueue"})
@Conditional(value={ReactiveDisabled.class})
public class RqueueViewController {
    private final RqueueWebConfig rqueueWebConfig;
    private final PebbleViewResolver rqueueViewResolver;
    private final RqueueViewControllerService rqueueViewControllerService;

    @Autowired
    public RqueueViewController(@Qualifier(value="rqueueViewResolver") PebbleViewResolver rqueueViewResolver, RqueueWebConfig rqueueWebConfig, RqueueViewControllerService rqueueViewControllerService) {
        this.rqueueViewControllerService = rqueueViewControllerService;
        this.rqueueWebConfig = rqueueWebConfig;
        this.rqueueViewResolver = rqueueViewResolver;
    }

    private String xForwardedPrefix(HttpServletRequest request) {
        return request.getHeader("x-forwarded-prefix");
    }

    @GetMapping
    public View index(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.rqueueViewControllerService.index(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("index", Locale.ENGLISH);
    }

    @GetMapping(value={"queues"})
    public View queues(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.rqueueViewControllerService.queues(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("queues", Locale.ENGLISH);
    }

    @GetMapping(value={"queues/{queueName}"})
    public View queueDetail(@PathVariable String queueName, Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.rqueueViewControllerService.queueDetail(model, this.xForwardedPrefix(request), queueName);
        return this.rqueueViewResolver.resolveViewName("queue_detail", Locale.ENGLISH);
    }

    @GetMapping(value={"running"})
    public View running(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.rqueueViewControllerService.running(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"scheduled"})
    public View scheduled(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.rqueueViewControllerService.scheduled(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"dead"})
    public View dead(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.rqueueViewControllerService.dead(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"pending"})
    public View pending(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.rqueueViewControllerService.pending(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"utility"})
    public View utility(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.rqueueViewControllerService.utility(model, this.xForwardedPrefix(request));
        return this.rqueueViewResolver.resolveViewName("utility", Locale.ENGLISH);
    }
}

