/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.support.RqueueMessageUtils;
import com.github.sonus21.rqueue.dao.RqueueMessageMetadataDao;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.models.enums.MessageStatus;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class RqueueMessageMetadataServiceImpl
implements RqueueMessageMetadataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageMetadataServiceImpl.class);
    private final RqueueMessageMetadataDao rqueueMessageMetadataDao;

    @Autowired
    public RqueueMessageMetadataServiceImpl(RqueueMessageMetadataDao rqueueMessageMetadataDao) {
        this.rqueueMessageMetadataDao = rqueueMessageMetadataDao;
    }

    @Override
    public MessageMetadata get(String id) {
        return this.rqueueMessageMetadataDao.get(id);
    }

    @Override
    public void delete(String id) {
        this.rqueueMessageMetadataDao.delete(id);
    }

    @Override
    public void deleteAll(Collection<String> ids) {
        this.rqueueMessageMetadataDao.deleteAll(ids);
    }

    @Override
    public List<MessageMetadata> findAll(Collection<String> ids) {
        return this.rqueueMessageMetadataDao.findAll(ids).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void save(MessageMetadata messageMetadata, Duration duration) {
        this.rqueueMessageMetadataDao.save(messageMetadata, duration);
    }

    @Override
    public MessageMetadata getByMessageId(String queueName, String messageId) {
        String id = RqueueMessageUtils.getMessageMetaId(queueName, messageId);
        return this.rqueueMessageMetadataDao.get(id);
    }

    @Override
    public void deleteMessage(String queueName, String messageId, Duration duration) {
        String id = RqueueMessageUtils.getMessageMetaId(queueName, messageId);
        MessageMetadata messageMetadata = this.rqueueMessageMetadataDao.get(id);
        if (messageMetadata == null) {
            messageMetadata = new MessageMetadata(id, MessageStatus.DELETED);
        }
        messageMetadata.setDeleted(true);
        messageMetadata.setDeletedOn(System.currentTimeMillis());
        this.rqueueMessageMetadataDao.save(messageMetadata, duration);
    }

    @Override
    public MessageMetadata getOrCreateMessageMetadata(RqueueMessage rqueueMessage) {
        MessageMetadata messageMetadata = this.getByMessageId(rqueueMessage.getQueueName(), rqueueMessage.getId());
        if (messageMetadata == null) {
            messageMetadata = new MessageMetadata(rqueueMessage, MessageStatus.ENQUEUED);
        }
        return messageMetadata;
    }

    @Override
    public Mono<Boolean> saveReactive(MessageMetadata messageMetadata, Duration duration) {
        return this.rqueueMessageMetadataDao.saveReactive(messageMetadata, duration);
    }
}

