/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.dao.RqueueStringDao;
import com.github.sonus21.rqueue.dao.RqueueSystemConfigDao;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.db.DeadLetterQueue;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.models.event.RqueueBootstrapEvent;
import com.github.sonus21.rqueue.models.response.BaseResponse;
import com.github.sonus21.rqueue.web.service.RqueueSystemManagerService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

@Service
public class RqueueSystemManagerServiceImpl
implements RqueueSystemManagerService {
    private final RqueueConfig rqueueConfig;
    private final RqueueStringDao rqueueStringDao;
    private final RqueueSystemConfigDao rqueueSystemConfigDao;

    @Autowired
    public RqueueSystemManagerServiceImpl(RqueueConfig rqueueConfig, RqueueStringDao rqueueStringDao, RqueueSystemConfigDao rqueueSystemConfigDao) {
        this.rqueueConfig = rqueueConfig;
        this.rqueueStringDao = rqueueStringDao;
        this.rqueueSystemConfigDao = rqueueSystemConfigDao;
    }

    private List<String> queueKeys(QueueConfig queueConfig) {
        ArrayList keys = Lists.newArrayList((Object[])new String[]{queueConfig.getQueueName(), queueConfig.getProcessingQueueName(), this.rqueueConfig.getQueueStatisticsKey(queueConfig.getName())});
        keys.add(queueConfig.getDelayedQueueName());
        if (queueConfig.hasDeadLetterQueue()) {
            for (DeadLetterQueue queue : queueConfig.getDeadLetterQueues()) {
                keys.add(queue.getName());
            }
        }
        return keys;
    }

    @Override
    public BaseResponse deleteQueue(String queueName) {
        QueueConfig queueConfig = this.rqueueSystemConfigDao.getConfigByName(queueName, true);
        BaseResponse baseResponse = new BaseResponse();
        if (queueConfig == null) {
            baseResponse.setCode(1);
            baseResponse.setMessage("Queue not found");
            return baseResponse;
        }
        queueConfig.setDeletedOn(System.currentTimeMillis());
        queueConfig.setDeleted(true);
        this.rqueueStringDao.deleteAndSet(this.queueKeys(queueConfig), Collections.singletonMap(queueConfig.getId(), queueConfig));
        baseResponse.setCode(0);
        baseResponse.setMessage("Queue deleted");
        return baseResponse;
    }

    private QueueConfig createOrUpdateConfig(QueueConfig queueConfig, QueueDetail queueDetail) {
        String qConfigId = this.rqueueConfig.getQueueConfigKey(queueDetail.getName());
        QueueConfig systemQueueConfig = queueConfig;
        boolean updated = false;
        boolean created = false;
        if (systemQueueConfig == null) {
            created = true;
            systemQueueConfig = queueDetail.toConfig();
            systemQueueConfig.setId(qConfigId);
        }
        if (queueDetail.isDlqSet()) {
            updated = systemQueueConfig.addDeadLetterQueue(queueDetail.getDeadLetterQueue());
        }
        updated = systemQueueConfig.updateVisibilityTimeout(queueDetail.getVisibilityTimeout()) || updated;
        updated = systemQueueConfig.updateConcurrency(queueDetail.getConcurrency().toMinMax()) || updated;
        updated = systemQueueConfig.updateRetryCount(queueDetail.getNumRetry()) || updated;
        updated = systemQueueConfig.updatePriorityGroup(queueDetail.getPriorityGroup()) || updated;
        boolean bl = updated = systemQueueConfig.updatePriority(queueDetail.getPriority()) || updated;
        if (updated && !created) {
            systemQueueConfig.updateTime();
        }
        if (updated || created) {
            return systemQueueConfig;
        }
        return null;
    }

    private void createOrUpdateConfigs(List<QueueDetail> queueDetails) {
        String[] queues = new String[queueDetails.size()];
        int i = 0;
        for (QueueDetail queueDetail : queueDetails) {
            queues[i++] = queueDetail.getName();
        }
        this.rqueueStringDao.appendToSet(this.rqueueConfig.getQueuesKey(), queues);
        List<String> ids = Arrays.stream(queues).map(this.rqueueConfig::getQueueConfigKey).collect(Collectors.toList());
        List<QueueConfig> queueConfigs = this.rqueueSystemConfigDao.findAllQConfig(ids);
        ArrayList<QueueConfig> newConfigs = new ArrayList<QueueConfig>();
        for (QueueDetail queueDetail : queueDetails) {
            QueueConfig newConfig;
            QueueConfig dbConfig = null;
            for (QueueConfig queueConfig : queueConfigs) {
                if (!queueConfig.getQueueName().equals(queueDetail.getQueueName())) continue;
                dbConfig = queueConfig;
                break;
            }
            if ((newConfig = this.createOrUpdateConfig(dbConfig, queueDetail)) == null) continue;
            newConfigs.add(newConfig);
        }
        if (!CollectionUtils.isEmpty(newConfigs)) {
            this.rqueueSystemConfigDao.saveAllQConfig(newConfigs);
        }
    }

    @Async
    public void onApplicationEvent(RqueueBootstrapEvent event) {
        if (event.isStartup()) {
            List<QueueDetail> queueDetails = EndpointRegistry.getActiveQueueDetails();
            if (queueDetails.isEmpty()) {
                return;
            }
            this.createOrUpdateConfigs(queueDetails);
        }
    }

    @Override
    public List<String> getQueues() {
        return this.rqueueStringDao.readFromSet(this.rqueueConfig.getQueuesKey());
    }

    @Override
    public List<QueueConfig> getQueueConfigs(Collection<String> queues) {
        Collection<String> ids = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(queues)) {
            ids = queues.stream().map(this.rqueueConfig::getQueueConfigKey).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(ids)) {
            return this.rqueueSystemConfigDao.findAllQConfig(ids);
        }
        return Collections.emptyList();
    }

    @Override
    public List<QueueConfig> getQueueConfigs() {
        List<String> queues = this.getQueues();
        return this.getQueueConfigs(queues);
    }

    @Override
    public List<QueueConfig> getSortedQueueConfigs() {
        List<String> queues = this.getQueues();
        return this.getQueueConfigs(queues).stream().sorted(Comparator.comparing(QueueConfig::getName)).collect(Collectors.toList());
    }

    @Override
    public QueueConfig getQueueConfig(String queueName) {
        List<QueueConfig> queueConfigs = this.getQueueConfigs(Collections.singletonList(queueName));
        if (CollectionUtils.isEmpty(queueConfigs)) {
            return null;
        }
        return queueConfigs.get(0);
    }

    @Override
    public Mono<BaseResponse> deleteReactiveQueue(String queueName) {
        return Mono.just((Object)this.deleteQueue(queueName));
    }
}

