/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.config;

import com.github.sonus21.rqueue.models.enums.RqueueMode;
import com.github.sonus21.rqueue.utils.StringUtils;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
public class RqueueConfig {
    private static final String brokerId = UUID.randomUUID().toString();
    private static final AtomicLong counter = new AtomicLong(1L);
    private final RedisConnectionFactory connectionFactory;
    private final ReactiveRedisConnectionFactory reactiveRedisConnectionFactory;
    private final boolean sharedConnection;
    private final int dbVersion;
    @Value(value="${rqueue.reactive.enabled:false}")
    private boolean reactiveEnabled;
    private String version = "";
    @Value(value="${rqueue.latest.version.check.enabled:true}")
    private boolean latestVersionCheckEnabled;
    @Value(value="${rqueue.key.prefix:__rq::}")
    private String prefix;
    @Value(value="${rqueue.del.prefix:del::")
    private String delPrefix;
    @Value(value="${rqueue.job.enabled:true}")
    private boolean jobEnabled;
    @Value(value="${rqueue.job.durability.in-terminal-state:1800}")
    private long jobDurabilityInTerminalStateInSecond;
    @Value(value="${rqueue.job.key.prefix:job::}")
    private String jobKeyPrefix;
    @Value(value="${rqueue.jobs.collection.name.prefix:jobs::}")
    private String jobsCollectionNamePrefix;
    @Value(value="${rqueue.cluster.mode:true}")
    private boolean clusterMode;
    @Value(value="${rqueue.simple.queue.prefix:}")
    private String simpleQueuePrefix;
    @Value(value="${rqueue.scheduled.queue.prefix:}")
    private String scheduledQueuePrefix;
    @Value(value="${rqueue.completed.queue.prefix:}")
    private String completedQueuePrefix;
    @Value(value="${rqueue.scheduled.queue.channel.prefix:}")
    private String scheduledQueueChannelPrefix;
    @Value(value="${rqueue.processing.queue.name.prefix:}")
    private String processingQueuePrefix;
    @Value(value="${rqueue.processing.queue.channel.prefix:}")
    private String processingQueueChannelPrefix;
    @Value(value="${rqueue.queues.key.suffix:queues}")
    private String queuesKeySuffix;
    @Value(value="${rqueue.lock.key.prefix:lock::}")
    private String lockKeyPrefix;
    @Value(value="${rqueue.queue.stat.key.prefix:q-stat::}")
    private String queueStatKeyPrefix;
    @Value(value="${rqueue.queue.config.key.prefix:q-config::}")
    private String queueConfigKeyPrefix;
    @Value(value="${rqueue.retry.per.poll:1}")
    private int retryPerPoll;
    @Value(value="${rqueue.net.proxy.host:}")
    private String proxyHost;
    @Value(value="${rqueue.net.proxy.port:8000}")
    private Integer proxyPort;
    @Value(value="${rqueue.net.proxy.type:HTTP}")
    private Proxy.Type proxyType;
    @Value(value="${rqueue.message.durability:10080}")
    private long messageDurabilityInMinute;
    @Value(value="${rqueue.message.durability.in-terminal-state:1800}")
    private long messageDurabilityInTerminalStateInSecond;
    @Value(value="${rqueue.system.mode:BOTH}")
    private RqueueMode mode;
    @Value(value="${rqueue.internal.communication.channel.name.prefix:i-channel}")
    private String internalChannelNamePrefix;
    @Value(value="${rqueue.completed.job.cleanup.interval:30000}")
    private long completedJobCleanupIntervalInMs;

    public static String getBrokerId() {
        return brokerId;
    }

    public boolean messageInTerminalStateShouldBeStored() {
        return this.getMessageDurabilityInTerminalStateInSecond() > 0L;
    }

    public long messageDurabilityInTerminalStateInMillisecond() {
        return this.getMessageDurabilityInTerminalStateInSecond() * 1000L;
    }

    public String getInternalCommChannelName() {
        return this.prefix + this.internalChannelNamePrefix;
    }

    public String getQueuesKey() {
        return this.prefix + this.queuesKeySuffix;
    }

    private String getSimpleQueueSuffix() {
        if (!StringUtils.isEmpty(this.simpleQueuePrefix)) {
            return this.simpleQueuePrefix;
        }
        if (this.dbVersion == 2) {
            return "queue::";
        }
        return "queue-v2::";
    }

    private String getScheduledQueueSuffix() {
        if (!StringUtils.isEmpty(this.scheduledQueuePrefix)) {
            return this.scheduledQueuePrefix;
        }
        if (this.dbVersion == 2) {
            return "d-queue::";
        }
        return "d-queue-v2::";
    }

    private String getCompletedQueueSuffix() {
        if (!StringUtils.isEmpty(this.completedQueuePrefix)) {
            return this.completedQueuePrefix;
        }
        return "c-queue::";
    }

    private String getScheduledQueueChannelSuffix() {
        if (!StringUtils.isEmpty(this.scheduledQueueChannelPrefix)) {
            return this.scheduledQueueChannelPrefix;
        }
        if (this.dbVersion == 2) {
            return "d-channel::";
        }
        return "d-channel-v2::";
    }

    private String getProcessingQueueSuffix() {
        if (!StringUtils.isEmpty(this.processingQueuePrefix)) {
            return this.processingQueuePrefix;
        }
        if (this.dbVersion == 2) {
            return "p-queue::";
        }
        return "p-queue-v2::";
    }

    private String getProcessingQueueChannelSuffix() {
        if (!StringUtils.isEmpty(this.processingQueueChannelPrefix)) {
            return this.processingQueueChannelPrefix;
        }
        if (this.dbVersion == 2) {
            return "p-channel::";
        }
        return "p-channel-v2::";
    }

    public String getQueueName(String queueName) {
        if (this.dbVersion == 1) {
            return queueName;
        }
        return this.prefix + this.getSimpleQueueSuffix() + this.getTaggedName(queueName);
    }

    public String getCompletedQueueName(String queueName) {
        return this.prefix + this.getCompletedQueueSuffix() + this.getTaggedName(queueName);
    }

    public String getScheduledQueueName(String queueName) {
        if (this.dbVersion == 1) {
            return "rqueue-delay::" + queueName;
        }
        return this.prefix + this.getScheduledQueueSuffix() + this.getTaggedName(queueName);
    }

    public String getScheduledQueueChannelName(String queueName) {
        if (this.dbVersion == 1) {
            return "rqueue-channel::" + queueName;
        }
        return this.prefix + this.getScheduledQueueChannelSuffix() + this.getTaggedName(queueName);
    }

    public String getProcessingQueueName(String queueName) {
        if (this.dbVersion == 1) {
            return "rqueue-processing::" + queueName;
        }
        return this.prefix + this.getProcessingQueueSuffix() + this.getTaggedName(queueName);
    }

    public String getProcessingQueueChannelName(String queueName) {
        if (this.dbVersion == 1) {
            return "rqueue-processing-channel::" + queueName;
        }
        return this.prefix + this.getProcessingQueueChannelSuffix() + this.getTaggedName(queueName);
    }

    public String getLockKey(String key) {
        return this.prefix + this.lockKeyPrefix + key;
    }

    public String getQueueStatisticsKey(String name) {
        return this.prefix + this.queueStatKeyPrefix + name;
    }

    public String getQueueConfigKey(String name) {
        return this.prefix + this.queueConfigKeyPrefix + name;
    }

    private String getTaggedName(String queueName) {
        if (!this.clusterMode) {
            return queueName;
        }
        boolean left = false;
        boolean right = false;
        char[] cArray = queueName.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (c.charValue() == '{') {
                left = true;
                continue;
            }
            if (c.charValue() != '}') continue;
            right = true;
        }
        if (left && right) {
            return queueName;
        }
        return "{" + queueName + "}";
    }

    public String getJobId() {
        return this.prefix + this.jobKeyPrefix + UUID.randomUUID().toString();
    }

    public String getJobsKey(String messageId) {
        return this.prefix + this.jobsCollectionNamePrefix + messageId;
    }

    public String getDelDataName(String queueName) {
        return this.prefix + this.delPrefix + brokerId + "::" + this.getTaggedName(queueName) + counter.incrementAndGet();
    }

    public Duration getJobDurabilityInTerminalState() {
        return Duration.ofSeconds(this.jobDurabilityInTerminalStateInSecond);
    }

    public String getLibVersion() {
        if (StringUtils.isEmpty(this.version)) {
            ClassPathResource resource = new ClassPathResource("META-INF/RQUEUE.MF", this.getClass().getClassLoader());
            try {
                InputStream inputStream = resource.getInputStream();
                String result = CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                for (String line : result.split("\n")) {
                    String[] words = line.trim().split(":");
                    if (2 != words.length || !words[0].equals("Version")) continue;
                    this.version = words[1].split("-")[0];
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.version;
    }

    public boolean isProducer() {
        return RqueueMode.PRODUCER.equals((Object)this.getMode());
    }

    public Duration getMessageDurability(Long messageLife) {
        if (messageLife == null || messageLife.intValue() == 0) {
            return Duration.ofMinutes(this.messageDurabilityInMinute);
        }
        Duration duration = Duration.ofMillis(2L * messageLife);
        if (duration.toMinutes() > this.messageDurabilityInMinute) {
            return duration;
        }
        return Duration.ofMinutes(this.messageDurabilityInMinute);
    }

    @Generated
    public RedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Generated
    public ReactiveRedisConnectionFactory getReactiveRedisConnectionFactory() {
        return this.reactiveRedisConnectionFactory;
    }

    @Generated
    public boolean isSharedConnection() {
        return this.sharedConnection;
    }

    @Generated
    public int getDbVersion() {
        return this.dbVersion;
    }

    @Generated
    public boolean isReactiveEnabled() {
        return this.reactiveEnabled;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean isLatestVersionCheckEnabled() {
        return this.latestVersionCheckEnabled;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public String getDelPrefix() {
        return this.delPrefix;
    }

    @Generated
    public boolean isJobEnabled() {
        return this.jobEnabled;
    }

    @Generated
    public long getJobDurabilityInTerminalStateInSecond() {
        return this.jobDurabilityInTerminalStateInSecond;
    }

    @Generated
    public String getJobKeyPrefix() {
        return this.jobKeyPrefix;
    }

    @Generated
    public String getJobsCollectionNamePrefix() {
        return this.jobsCollectionNamePrefix;
    }

    @Generated
    public boolean isClusterMode() {
        return this.clusterMode;
    }

    @Generated
    public String getSimpleQueuePrefix() {
        return this.simpleQueuePrefix;
    }

    @Generated
    public String getScheduledQueuePrefix() {
        return this.scheduledQueuePrefix;
    }

    @Generated
    public String getCompletedQueuePrefix() {
        return this.completedQueuePrefix;
    }

    @Generated
    public String getScheduledQueueChannelPrefix() {
        return this.scheduledQueueChannelPrefix;
    }

    @Generated
    public String getProcessingQueuePrefix() {
        return this.processingQueuePrefix;
    }

    @Generated
    public String getProcessingQueueChannelPrefix() {
        return this.processingQueueChannelPrefix;
    }

    @Generated
    public String getQueuesKeySuffix() {
        return this.queuesKeySuffix;
    }

    @Generated
    public String getLockKeyPrefix() {
        return this.lockKeyPrefix;
    }

    @Generated
    public String getQueueStatKeyPrefix() {
        return this.queueStatKeyPrefix;
    }

    @Generated
    public String getQueueConfigKeyPrefix() {
        return this.queueConfigKeyPrefix;
    }

    @Generated
    public int getRetryPerPoll() {
        return this.retryPerPoll;
    }

    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Generated
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Generated
    public Proxy.Type getProxyType() {
        return this.proxyType;
    }

    @Generated
    public long getMessageDurabilityInMinute() {
        return this.messageDurabilityInMinute;
    }

    @Generated
    public long getMessageDurabilityInTerminalStateInSecond() {
        return this.messageDurabilityInTerminalStateInSecond;
    }

    @Generated
    public RqueueMode getMode() {
        return this.mode;
    }

    @Generated
    public String getInternalChannelNamePrefix() {
        return this.internalChannelNamePrefix;
    }

    @Generated
    public long getCompletedJobCleanupIntervalInMs() {
        return this.completedJobCleanupIntervalInMs;
    }

    @Generated
    public void setReactiveEnabled(boolean reactiveEnabled) {
        this.reactiveEnabled = reactiveEnabled;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setLatestVersionCheckEnabled(boolean latestVersionCheckEnabled) {
        this.latestVersionCheckEnabled = latestVersionCheckEnabled;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public void setDelPrefix(String delPrefix) {
        this.delPrefix = delPrefix;
    }

    @Generated
    public void setJobEnabled(boolean jobEnabled) {
        this.jobEnabled = jobEnabled;
    }

    @Generated
    public void setJobDurabilityInTerminalStateInSecond(long jobDurabilityInTerminalStateInSecond) {
        this.jobDurabilityInTerminalStateInSecond = jobDurabilityInTerminalStateInSecond;
    }

    @Generated
    public void setJobKeyPrefix(String jobKeyPrefix) {
        this.jobKeyPrefix = jobKeyPrefix;
    }

    @Generated
    public void setJobsCollectionNamePrefix(String jobsCollectionNamePrefix) {
        this.jobsCollectionNamePrefix = jobsCollectionNamePrefix;
    }

    @Generated
    public void setClusterMode(boolean clusterMode) {
        this.clusterMode = clusterMode;
    }

    @Generated
    public void setSimpleQueuePrefix(String simpleQueuePrefix) {
        this.simpleQueuePrefix = simpleQueuePrefix;
    }

    @Generated
    public void setScheduledQueuePrefix(String scheduledQueuePrefix) {
        this.scheduledQueuePrefix = scheduledQueuePrefix;
    }

    @Generated
    public void setCompletedQueuePrefix(String completedQueuePrefix) {
        this.completedQueuePrefix = completedQueuePrefix;
    }

    @Generated
    public void setScheduledQueueChannelPrefix(String scheduledQueueChannelPrefix) {
        this.scheduledQueueChannelPrefix = scheduledQueueChannelPrefix;
    }

    @Generated
    public void setProcessingQueuePrefix(String processingQueuePrefix) {
        this.processingQueuePrefix = processingQueuePrefix;
    }

    @Generated
    public void setProcessingQueueChannelPrefix(String processingQueueChannelPrefix) {
        this.processingQueueChannelPrefix = processingQueueChannelPrefix;
    }

    @Generated
    public void setQueuesKeySuffix(String queuesKeySuffix) {
        this.queuesKeySuffix = queuesKeySuffix;
    }

    @Generated
    public void setLockKeyPrefix(String lockKeyPrefix) {
        this.lockKeyPrefix = lockKeyPrefix;
    }

    @Generated
    public void setQueueStatKeyPrefix(String queueStatKeyPrefix) {
        this.queueStatKeyPrefix = queueStatKeyPrefix;
    }

    @Generated
    public void setQueueConfigKeyPrefix(String queueConfigKeyPrefix) {
        this.queueConfigKeyPrefix = queueConfigKeyPrefix;
    }

    @Generated
    public void setRetryPerPoll(int retryPerPoll) {
        this.retryPerPoll = retryPerPoll;
    }

    @Generated
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Generated
    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Generated
    public void setProxyType(Proxy.Type proxyType) {
        this.proxyType = proxyType;
    }

    @Generated
    public void setMessageDurabilityInMinute(long messageDurabilityInMinute) {
        this.messageDurabilityInMinute = messageDurabilityInMinute;
    }

    @Generated
    public void setMessageDurabilityInTerminalStateInSecond(long messageDurabilityInTerminalStateInSecond) {
        this.messageDurabilityInTerminalStateInSecond = messageDurabilityInTerminalStateInSecond;
    }

    @Generated
    public void setMode(RqueueMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setInternalChannelNamePrefix(String internalChannelNamePrefix) {
        this.internalChannelNamePrefix = internalChannelNamePrefix;
    }

    @Generated
    public void setCompletedJobCleanupIntervalInMs(long completedJobCleanupIntervalInMs) {
        this.completedJobCleanupIntervalInMs = completedJobCleanupIntervalInMs;
    }

    @Generated
    public RqueueConfig(RedisConnectionFactory connectionFactory, ReactiveRedisConnectionFactory reactiveRedisConnectionFactory, boolean sharedConnection, int dbVersion) {
        this.connectionFactory = connectionFactory;
        this.reactiveRedisConnectionFactory = reactiveRedisConnectionFactory;
        this.sharedConnection = sharedConnection;
        this.dbVersion = dbVersion;
    }
}

