/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.config;

import com.github.sonus21.rqueue.common.RqueueLockManager;
import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.common.impl.RqueueLockManagerImpl;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueSchedulerConfig;
import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.config.SimpleRqueueListenerContainerFactory;
import com.github.sonus21.rqueue.converter.MessageConverterProvider;
import com.github.sonus21.rqueue.core.ProcessingQueueMessageScheduler;
import com.github.sonus21.rqueue.core.RqueueBeanProvider;
import com.github.sonus21.rqueue.core.RqueueInternalPubSubChannel;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.RqueueRedisListenerContainerFactory;
import com.github.sonus21.rqueue.core.ScheduledQueueMessageScheduler;
import com.github.sonus21.rqueue.core.impl.RqueueMessageTemplateImpl;
import com.github.sonus21.rqueue.dao.RqueueStringDao;
import com.github.sonus21.rqueue.dao.impl.RqueueStringDaoImpl;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.metrics.RqueueQueueMetrics;
import com.github.sonus21.rqueue.utils.RedisUtils;
import com.github.sonus21.rqueue.utils.condition.ReactiveEnabled;
import com.github.sonus21.rqueue.utils.pebble.ResourceLoader;
import com.github.sonus21.rqueue.utils.pebble.RqueuePebbleExtension;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.extension.Extension;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.spring.extension.SpringExtension;
import io.pebbletemplates.spring.reactive.PebbleReactiveViewResolver;
import io.pebbletemplates.spring.servlet.PebbleViewResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.servlet.ViewResolver;

public abstract class RqueueListenerBaseConfig {
    public static final int MAX_DB_VERSION = 2;
    private static final String TEMPLATE_DIR = "templates/rqueue/";
    private static final String TEMPLATE_SUFFIX = ".html";
    @Autowired(required=false)
    protected final SimpleRqueueListenerContainerFactory simpleRqueueListenerContainerFactory = new SimpleRqueueListenerContainerFactory();
    @Value(value="${rqueue.reactive.enabled:false}")
    protected boolean reactiveEnabled;
    @Value(value="${rqueue.message.converter.provider.class:com.github.sonus21.rqueue.converter.DefaultMessageConverterProvider}")
    private String messageConverterProviderClass;

    protected MessageConverterProvider getMessageConverterProvider() {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(this.messageConverterProviderClass);
            Object messageProvider = c.newInstance();
            if (messageProvider instanceof MessageConverterProvider) {
                return (MessageConverterProvider)messageProvider;
            }
            throw new IllegalStateException("configured message converter is not of type MessageConverterProvider, type: '" + this.messageConverterProviderClass + "'", new Exception());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("MessageConverterProvider class '" + this.messageConverterProviderClass + "' loading failed ", e);
        }
    }

    @Bean
    public RqueueConfig rqueueConfig(ConfigurableBeanFactory beanFactory, @Value(value="${rqueue.version.key:__rq::version}") String versionKey, @Value(value="${rqueue.db.version:}") Integer dbVersion) {
        int version;
        boolean sharedConnection = false;
        if (this.simpleRqueueListenerContainerFactory.getRedisConnectionFactory() == null) {
            sharedConnection = true;
            this.simpleRqueueListenerContainerFactory.setRedisConnectionFactory((RedisConnectionFactory)beanFactory.getBean(RedisConnectionFactory.class));
        }
        if (this.reactiveEnabled && this.simpleRqueueListenerContainerFactory.getReactiveRedisConnectionFactory() == null) {
            sharedConnection = true;
            this.simpleRqueueListenerContainerFactory.setReactiveRedisConnectionFactory((ReactiveRedisConnectionFactory)beanFactory.getBean(ReactiveRedisConnectionFactory.class));
        }
        RedisConnectionFactory connectionFactory = this.simpleRqueueListenerContainerFactory.getRedisConnectionFactory();
        RqueueRedisTemplate<Integer> rqueueRedisTemplate = new RqueueRedisTemplate<Integer>(connectionFactory);
        if (dbVersion == null) {
            version = RedisUtils.updateAndGetVersion(rqueueRedisTemplate, versionKey, 2);
        } else if (dbVersion >= 1 && dbVersion <= 2) {
            RedisUtils.setVersion(rqueueRedisTemplate, versionKey, dbVersion);
            version = dbVersion;
        } else {
            throw new IllegalStateException("Rqueue db version '" + dbVersion + "' is not correct");
        }
        return new RqueueConfig(connectionFactory, this.simpleRqueueListenerContainerFactory.getReactiveRedisConnectionFactory(), sharedConnection, version);
    }

    @Bean
    public RqueueWebConfig rqueueWebConfig() {
        return new RqueueWebConfig();
    }

    @Bean
    public RqueueSchedulerConfig rqueueSchedulerConfig() {
        return new RqueueSchedulerConfig();
    }

    protected RqueueMessageTemplate getMessageTemplate(RqueueConfig rqueueConfig) {
        if (this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate() != null) {
            return this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate();
        }
        this.simpleRqueueListenerContainerFactory.setRqueueMessageTemplate(new RqueueMessageTemplateImpl(rqueueConfig.getConnectionFactory(), rqueueConfig.getReactiveRedisConnectionFactory()));
        return this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate();
    }

    @Bean
    public RedisTemplate<String, Long> rqueueRedisLongTemplate(RqueueConfig rqueueConfig) {
        return RedisUtils.getRedisTemplate(rqueueConfig.getConnectionFactory());
    }

    @Bean
    public RqueueRedisListenerContainerFactory rqueueRedisListenerContainerFactory() {
        return new RqueueRedisListenerContainerFactory();
    }

    @Bean
    public ScheduledQueueMessageScheduler scheduledMessageScheduler() {
        return new ScheduledQueueMessageScheduler();
    }

    @Bean
    public ProcessingQueueMessageScheduler processingMessageScheduler() {
        return new ProcessingQueueMessageScheduler();
    }

    @Bean
    public RqueueRedisTemplate<String> stringRqueueRedisTemplate(RqueueConfig rqueueConfig) {
        return new RqueueRedisTemplate<String>(rqueueConfig.getConnectionFactory());
    }

    @Bean
    public RqueueStringDao rqueueStringDao(RqueueConfig rqueueConfig) {
        return new RqueueStringDaoImpl(rqueueConfig);
    }

    @Bean
    public RqueueLockManager rqueueLockManager(RqueueStringDao rqueueStringDao) {
        return new RqueueLockManagerImpl(rqueueStringDao);
    }

    private PebbleEngine createPebbleEngine() {
        ResourceLoader loader = new ResourceLoader();
        loader.setPrefix(TEMPLATE_DIR);
        loader.setSuffix(TEMPLATE_SUFFIX);
        return new PebbleEngine.Builder().extension(new Extension[]{new RqueuePebbleExtension(), new SpringExtension(null)}).loader((Loader)loader).build();
    }

    @Bean
    public ViewResolver rqueueViewResolver() {
        PebbleViewResolver resolver = new PebbleViewResolver(this.createPebbleEngine());
        resolver.setPrefix(TEMPLATE_DIR);
        resolver.setSuffix(TEMPLATE_SUFFIX);
        return resolver;
    }

    @Bean
    @Conditional(value={ReactiveEnabled.class})
    public org.springframework.web.reactive.result.view.ViewResolver reactiveRqueueViewResolver() {
        PebbleReactiveViewResolver resolver = new PebbleReactiveViewResolver(this.createPebbleEngine());
        resolver.setPrefix(TEMPLATE_DIR);
        resolver.setSuffix(TEMPLATE_SUFFIX);
        return resolver;
    }

    @Bean
    public RqueueQueueMetrics rqueueQueueMetrics(RqueueRedisTemplate<String> stringRqueueRedisTemplate) {
        return new RqueueQueueMetrics(stringRqueueRedisTemplate);
    }

    @Bean
    public RqueueBeanProvider rqueueBeanProvider() {
        return new RqueueBeanProvider();
    }

    @Bean
    public RqueueInternalPubSubChannel rqueueInternalPubSubChannel(RqueueRedisListenerContainerFactory rqueueRedisListenerContainerFactory, RqueueMessageListenerContainer rqueueMessageListenerContainer, RqueueConfig rqueueConfig, RqueueBeanProvider rqueueBeanProvider, @Qualifier(value="stringRqueueRedisTemplate") RqueueRedisTemplate<String> stringRqueueRedisTemplate) {
        return new RqueueInternalPubSubChannel(rqueueRedisListenerContainerFactory, rqueueMessageListenerContainer, rqueueConfig, stringRqueueRedisTemplate, rqueueBeanProvider);
    }
}

