/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.sonus21.rqueue.models.SerializableBase;
import lombok.Generated;
import org.springframework.messaging.MessageHeaders;

@JsonPropertyOrder(value={"failureCount"})
public class RqueueMessage
extends SerializableBase {
    private static final long serialVersionUID = -3488860960637488519L;
    private String id;
    private String queueName;
    private String message;
    private Integer retryCount;
    private long queuedTime;
    private long processAt;
    private Long reEnqueuedAt;
    private int failureCount;
    private int sourceQueueFailureCount;
    private String sourceQueueName;
    private long period;
    @JsonIgnore
    private MessageHeaders messageHeaders;

    @JsonIgnore
    public RqueueMessage updateReEnqueuedAt() {
        this.reEnqueuedAt = System.currentTimeMillis();
        return this;
    }

    @Override
    public boolean equals(Object other) {
        RqueueMessage otherMessage;
        if (other instanceof RqueueMessage && (otherMessage = (RqueueMessage)other).getId() != null && this.getId() != null) {
            return this.getId().equals(otherMessage.getId());
        }
        return false;
    }

    @JsonIgnore
    public long nextProcessAt() {
        if (this.isPeriodic()) {
            return this.processAt + this.period;
        }
        throw new IllegalStateException("Only applicable for periodic message");
    }

    @JsonIgnore
    public boolean isPeriodic() {
        return this.period > 0L;
    }

    @Generated
    public static RqueueMessageBuilder builder() {
        return new RqueueMessageBuilder();
    }

    @Generated
    public RqueueMessageBuilder toBuilder() {
        return new RqueueMessageBuilder().id(this.id).queueName(this.queueName).message(this.message).retryCount(this.retryCount).queuedTime(this.queuedTime).processAt(this.processAt).reEnqueuedAt(this.reEnqueuedAt).failureCount(this.failureCount).sourceQueueFailureCount(this.sourceQueueFailureCount).sourceQueueName(this.sourceQueueName).period(this.period).messageHeaders(this.messageHeaders);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Integer getRetryCount() {
        return this.retryCount;
    }

    @Generated
    public long getQueuedTime() {
        return this.queuedTime;
    }

    @Generated
    public long getProcessAt() {
        return this.processAt;
    }

    @Generated
    public Long getReEnqueuedAt() {
        return this.reEnqueuedAt;
    }

    @Generated
    public int getFailureCount() {
        return this.failureCount;
    }

    @Generated
    public int getSourceQueueFailureCount() {
        return this.sourceQueueFailureCount;
    }

    @Generated
    public String getSourceQueueName() {
        return this.sourceQueueName;
    }

    @Generated
    public long getPeriod() {
        return this.period;
    }

    @Generated
    public MessageHeaders getMessageHeaders() {
        return this.messageHeaders;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    @Generated
    public void setQueuedTime(long queuedTime) {
        this.queuedTime = queuedTime;
    }

    @Generated
    public void setProcessAt(long processAt) {
        this.processAt = processAt;
    }

    @Generated
    public void setReEnqueuedAt(Long reEnqueuedAt) {
        this.reEnqueuedAt = reEnqueuedAt;
    }

    @Generated
    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    @Generated
    public void setSourceQueueFailureCount(int sourceQueueFailureCount) {
        this.sourceQueueFailureCount = sourceQueueFailureCount;
    }

    @Generated
    public void setSourceQueueName(String sourceQueueName) {
        this.sourceQueueName = sourceQueueName;
    }

    @Generated
    public void setPeriod(long period) {
        this.period = period;
    }

    @JsonIgnore
    @Generated
    public void setMessageHeaders(MessageHeaders messageHeaders) {
        this.messageHeaders = messageHeaders;
    }

    @Generated
    public String toString() {
        return "RqueueMessage(id=" + this.getId() + ", queueName=" + this.getQueueName() + ", message=" + this.getMessage() + ", retryCount=" + this.getRetryCount() + ", queuedTime=" + this.getQueuedTime() + ", processAt=" + this.getProcessAt() + ", reEnqueuedAt=" + this.getReEnqueuedAt() + ", failureCount=" + this.getFailureCount() + ", sourceQueueFailureCount=" + this.getSourceQueueFailureCount() + ", sourceQueueName=" + this.getSourceQueueName() + ", period=" + this.getPeriod() + ")";
    }

    @Generated
    public RqueueMessage() {
    }

    @Generated
    public RqueueMessage(String id, String queueName, String message, Integer retryCount, long queuedTime, long processAt, Long reEnqueuedAt, int failureCount, int sourceQueueFailureCount, String sourceQueueName, long period, MessageHeaders messageHeaders) {
        this.id = id;
        this.queueName = queueName;
        this.message = message;
        this.retryCount = retryCount;
        this.queuedTime = queuedTime;
        this.processAt = processAt;
        this.reEnqueuedAt = reEnqueuedAt;
        this.failureCount = failureCount;
        this.sourceQueueFailureCount = sourceQueueFailureCount;
        this.sourceQueueName = sourceQueueName;
        this.period = period;
        this.messageHeaders = messageHeaders;
    }

    @Generated
    public static class RqueueMessageBuilder {
        @Generated
        private String id;
        @Generated
        private String queueName;
        @Generated
        private String message;
        @Generated
        private Integer retryCount;
        @Generated
        private long queuedTime;
        @Generated
        private long processAt;
        @Generated
        private Long reEnqueuedAt;
        @Generated
        private int failureCount;
        @Generated
        private int sourceQueueFailureCount;
        @Generated
        private String sourceQueueName;
        @Generated
        private long period;
        @Generated
        private MessageHeaders messageHeaders;

        @Generated
        RqueueMessageBuilder() {
        }

        @Generated
        public RqueueMessageBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public RqueueMessageBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        @Generated
        public RqueueMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public RqueueMessageBuilder retryCount(Integer retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        @Generated
        public RqueueMessageBuilder queuedTime(long queuedTime) {
            this.queuedTime = queuedTime;
            return this;
        }

        @Generated
        public RqueueMessageBuilder processAt(long processAt) {
            this.processAt = processAt;
            return this;
        }

        @Generated
        public RqueueMessageBuilder reEnqueuedAt(Long reEnqueuedAt) {
            this.reEnqueuedAt = reEnqueuedAt;
            return this;
        }

        @Generated
        public RqueueMessageBuilder failureCount(int failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        @Generated
        public RqueueMessageBuilder sourceQueueFailureCount(int sourceQueueFailureCount) {
            this.sourceQueueFailureCount = sourceQueueFailureCount;
            return this;
        }

        @Generated
        public RqueueMessageBuilder sourceQueueName(String sourceQueueName) {
            this.sourceQueueName = sourceQueueName;
            return this;
        }

        @Generated
        public RqueueMessageBuilder period(long period) {
            this.period = period;
            return this;
        }

        @JsonIgnore
        @Generated
        public RqueueMessageBuilder messageHeaders(MessageHeaders messageHeaders) {
            this.messageHeaders = messageHeaders;
            return this;
        }

        @Generated
        public RqueueMessage build() {
            return new RqueueMessage(this.id, this.queueName, this.message, this.retryCount, this.queuedTime, this.processAt, this.reEnqueuedAt, this.failureCount, this.sourceQueueFailureCount, this.sourceQueueName, this.period, this.messageHeaders);
        }

        @Generated
        public String toString() {
            return "RqueueMessage.RqueueMessageBuilder(id=" + this.id + ", queueName=" + this.queueName + ", message=" + this.message + ", retryCount=" + this.retryCount + ", queuedTime=" + this.queuedTime + ", processAt=" + this.processAt + ", reEnqueuedAt=" + this.reEnqueuedAt + ", failureCount=" + this.failureCount + ", sourceQueueFailureCount=" + this.sourceQueueFailureCount + ", sourceQueueName=" + this.sourceQueueName + ", period=" + this.period + ", messageHeaders=" + this.messageHeaders + ")";
        }
    }
}

