/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.MessageSweeper;
import com.github.sonus21.rqueue.core.support.RqueueMessageUtils;
import com.github.sonus21.rqueue.dao.RqueueStringDao;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.models.enums.MessageStatus;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.Validator;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

abstract class BaseMessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseMessageSender.class);
    protected final MessageHeaders messageHeaders;
    protected final MessageConverter messageConverter;
    protected final RqueueMessageTemplate messageTemplate;
    @Autowired
    protected RqueueStringDao rqueueStringDao;
    @Autowired
    protected RqueueConfig rqueueConfig;
    @Autowired
    protected RqueueMessageMetadataService rqueueMessageMetadataService;

    BaseMessageSender(RqueueMessageTemplate messageTemplate, MessageConverter messageConverter, MessageHeaders messageHeaders) {
        Assert.notNull((Object)messageTemplate, (String)"messageTemplate cannot be null");
        Assert.notNull((Object)messageConverter, (String)"messageConverter cannot be null");
        this.messageTemplate = messageTemplate;
        this.messageConverter = messageConverter;
        this.messageHeaders = messageHeaders;
    }

    protected Object storeMessageMetadata(RqueueMessage rqueueMessage, Long delayInMillis, boolean reactive) {
        MessageMetadata messageMetadata = new MessageMetadata(rqueueMessage, MessageStatus.ENQUEUED);
        Duration duration = this.rqueueConfig.getMessageDurability(delayInMillis);
        if (reactive) {
            return this.rqueueMessageMetadataService.saveReactive(messageMetadata, duration);
        }
        this.rqueueMessageMetadataService.save(messageMetadata, duration);
        return null;
    }

    protected Object enqueue(QueueDetail queueDetail, RqueueMessage rqueueMessage, Long delayInMilliSecs, boolean reactive) {
        if (delayInMilliSecs == null || delayInMilliSecs <= 100L) {
            if (reactive) {
                return this.messageTemplate.addReactiveMessage(queueDetail.getQueueName(), rqueueMessage);
            }
            this.messageTemplate.addMessage(queueDetail.getQueueName(), rqueueMessage);
        } else {
            if (reactive) {
                return this.messageTemplate.addReactiveMessageWithDelay(queueDetail.getScheduledQueueName(), queueDetail.getScheduledQueueChannelName(), rqueueMessage);
            }
            this.messageTemplate.addMessageWithDelay(queueDetail.getScheduledQueueName(), queueDetail.getScheduledQueueChannelName(), rqueueMessage);
        }
        return null;
    }

    protected String pushMessage(String queueName, String messageId, Object message, Integer retryCount, Long delayInMilliSecs) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        RqueueMessage rqueueMessage = RqueueMessageUtils.buildMessage(this.messageConverter, queueName, messageId, message, retryCount, delayInMilliSecs, this.messageHeaders);
        try {
            this.enqueue(queueDetail, rqueueMessage, delayInMilliSecs, false);
            this.storeMessageMetadata(rqueueMessage, delayInMilliSecs, false);
        }
        catch (Exception e) {
            log.error("Queue: {} Message {} could not be pushed {}", new Object[]{queueName, rqueueMessage, e});
            return null;
        }
        return rqueueMessage.getId();
    }

    protected String pushPeriodicMessage(String queueName, String messageId, Object message, long periodInMilliSeconds) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        RqueueMessage rqueueMessage = RqueueMessageUtils.buildPeriodicMessage(this.messageConverter, queueName, messageId, message, null, periodInMilliSeconds, this.messageHeaders);
        try {
            this.enqueue(queueDetail, rqueueMessage, periodInMilliSeconds, false);
            this.storeMessageMetadata(rqueueMessage, periodInMilliSeconds, false);
        }
        catch (Exception e) {
            log.error("Queue: {} Message {} could not be pushed {}", new Object[]{queueName, rqueueMessage, e});
            return null;
        }
        return rqueueMessage.getId();
    }

    protected Object deleteAllMessages(QueueDetail queueDetail) {
        return MessageSweeper.getInstance(this.rqueueConfig, this.messageTemplate, this.rqueueMessageMetadataService).deleteAllMessages(MessageSweeper.MessageDeleteRequest.builder().queueDetail(queueDetail).build());
    }

    protected void registerQueueInternal(String queueName, String ... priorities) {
        Validator.validateQueue(queueName);
        Assert.notNull((Object)priorities, (String)"priorities cannot be null");
        HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        priorityMap.put("DEFAULT_PRIORITY", 1);
        for (String priority : priorities) {
            priorityMap.put(priority, 1);
        }
        QueueDetail queueDetail = QueueDetail.builder().name(queueName).active(false).queueName(this.rqueueConfig.getQueueName(queueName)).scheduledQueueName(this.rqueueConfig.getScheduledQueueName(queueName)).scheduledQueueChannelName(this.rqueueConfig.getScheduledQueueChannelName(queueName)).processingQueueName(this.rqueueConfig.getProcessingQueueName(queueName)).processingQueueChannelName(this.rqueueConfig.getProcessingQueueChannelName(queueName)).priority(priorityMap).build();
        EndpointRegistry.register(queueDetail);
        for (String priority : priorities) {
            String suffix = PriorityUtils.getSuffix(priority);
            queueDetail = QueueDetail.builder().name(queueName + suffix).active(false).queueName(this.rqueueConfig.getQueueName(queueName) + suffix).scheduledQueueName(this.rqueueConfig.getScheduledQueueName(queueName) + suffix).scheduledQueueChannelName(this.rqueueConfig.getScheduledQueueChannelName(queueName) + suffix).processingQueueName(this.rqueueConfig.getProcessingQueueName(queueName) + suffix).processingQueueChannelName(this.rqueueConfig.getProcessingQueueChannelName(queueName) + suffix).priority(Collections.singletonMap("DEFAULT_PRIORITY", 1)).build();
            EndpointRegistry.register(queueDetail);
        }
    }
}

