/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.support.RqueueMessageUtils;
import com.github.sonus21.rqueue.exception.UnknownSwitchCase;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.utils.RetryableRunnable;
import com.github.sonus21.rqueue.utils.StringUtils;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.DataType;
import org.springframework.util.CollectionUtils;

public class MessageSweeper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSweeper.class);
    private static MessageSweeper messageSweeper;
    private final ExecutorService executorService;
    private final RqueueMessageTemplate messageTemplate;
    private final RqueueMessageMetadataService rqueueMessageMetadataService;
    private final RqueueConfig rqueueConfig;

    private MessageSweeper(RqueueConfig rqueueConfig, RqueueMessageTemplate messageTemplate, RqueueMessageMetadataService rqueueMessageMetadataService) {
        this.rqueueMessageMetadataService = rqueueMessageMetadataService;
        this.executorService = Executors.newSingleThreadExecutor();
        this.messageTemplate = messageTemplate;
        this.rqueueConfig = rqueueConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageSweeper getInstance(RqueueConfig rqueueConfig, RqueueMessageTemplate messageTemplate, RqueueMessageMetadataService rqueueMessageMetadataDao) {
        if (messageSweeper == null) {
            Class<MessageSweeper> clazz = MessageSweeper.class;
            synchronized (MessageSweeper.class) {
                if (messageSweeper == null) {
                    messageSweeper = new MessageSweeper(rqueueConfig, messageTemplate, rqueueMessageMetadataDao);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return messageSweeper;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return messageSweeper;
            }
        }
        return messageSweeper;
    }

    public boolean deleteAllMessages(MessageDeleteRequest request) {
        log.debug("MessageDeleteRequest {}", (Object)request);
        if (!request.isValid()) {
            throw new IllegalArgumentException("Message request is not valid");
        }
        ArrayList<DeleteJobData> deleteJobData = new ArrayList<DeleteJobData>();
        QueueDetail detail = request.queueDetail;
        if (detail != null) {
            String newQueueName = this.rqueueConfig.getDelDataName(detail.getQueueName());
            String newScheduledZsetName = this.rqueueConfig.getDelDataName(detail.getQueueName());
            String newProcessingZsetName = this.rqueueConfig.getDelDataName(detail.getQueueName());
            this.messageTemplate.renameCollections(Arrays.asList(detail.getQueueName(), detail.getScheduledQueueName(), detail.getProcessingQueueName()), Arrays.asList(newQueueName, newScheduledZsetName, newProcessingZsetName));
            deleteJobData.add(new DeleteJobData(newQueueName, DataType.LIST));
            deleteJobData.add(new DeleteJobData(newScheduledZsetName, DataType.ZSET));
            deleteJobData.add(new DeleteJobData(newProcessingZsetName, DataType.ZSET));
        } else {
            switch (request.dataType) {
                case LIST: {
                    DeleteJobData data = new DeleteJobData(this.rqueueConfig.getDelDataName(request.dataName), request.dataType);
                    this.messageTemplate.renameCollection(request.dataName, data.name);
                    deleteJobData.add(data);
                    break;
                }
                case ZSET: {
                    DeleteJobData data = new DeleteJobData(this.rqueueConfig.getDelDataName(request.dataName), request.dataType);
                    this.messageTemplate.renameCollection(request.dataName, data.name);
                    deleteJobData.add(data);
                    break;
                }
                default: {
                    throw new UnknownSwitchCase(request.dataType.code());
                }
            }
        }
        if (!CollectionUtils.isEmpty(deleteJobData)) {
            if (detail != null) {
                this.executorService.submit(new MessageDeleteJob(deleteJobData, detail.getName()));
            } else {
                this.executorService.submit(new MessageDeleteJob(deleteJobData, request.queueName));
            }
        }
        return true;
    }

    public static class MessageDeleteRequest {
        private final QueueDetail queueDetail;
        private final String dataName;
        private final String queueName;
        private final DataType dataType;

        private boolean isValid() {
            if (this.queueDetail != null) {
                return true;
            }
            return !StringUtils.isEmpty(this.dataName) && !StringUtils.isEmpty(this.queueName) && Arrays.asList(DataType.LIST, DataType.ZSET).contains(this.dataType);
        }

        @Generated
        MessageDeleteRequest(QueueDetail queueDetail, String dataName, String queueName, DataType dataType) {
            this.queueDetail = queueDetail;
            this.dataName = dataName;
            this.queueName = queueName;
            this.dataType = dataType;
        }

        @Generated
        public static MessageDeleteRequestBuilder builder() {
            return new MessageDeleteRequestBuilder();
        }

        @Generated
        public String toString() {
            return "MessageSweeper.MessageDeleteRequest(queueDetail=" + this.queueDetail + ", dataName=" + this.dataName + ", queueName=" + this.queueName + ", dataType=" + this.dataType + ")";
        }

        @Generated
        public static class MessageDeleteRequestBuilder {
            @Generated
            private QueueDetail queueDetail;
            @Generated
            private String dataName;
            @Generated
            private String queueName;
            @Generated
            private DataType dataType;

            @Generated
            MessageDeleteRequestBuilder() {
            }

            @Generated
            public MessageDeleteRequestBuilder queueDetail(QueueDetail queueDetail) {
                this.queueDetail = queueDetail;
                return this;
            }

            @Generated
            public MessageDeleteRequestBuilder dataName(String dataName) {
                this.dataName = dataName;
                return this;
            }

            @Generated
            public MessageDeleteRequestBuilder queueName(String queueName) {
                this.queueName = queueName;
                return this;
            }

            @Generated
            public MessageDeleteRequestBuilder dataType(DataType dataType) {
                this.dataType = dataType;
                return this;
            }

            @Generated
            public MessageDeleteRequest build() {
                return new MessageDeleteRequest(this.queueDetail, this.dataName, this.queueName, this.dataType);
            }

            @Generated
            public String toString() {
                return "MessageSweeper.MessageDeleteRequest.MessageDeleteRequestBuilder(queueDetail=" + this.queueDetail + ", dataName=" + this.dataName + ", queueName=" + this.queueName + ", dataType=" + this.dataType + ")";
            }
        }
    }

    private static class DeleteJobData {
        private final String name;
        private final DataType type;

        @Generated
        public DeleteJobData(String name, DataType type) {
            this.name = name;
            this.type = type;
        }
    }

    private class MessageDeleteJob
    extends RetryableRunnable<DeleteJobData> {
        private static final int batchSize = 1000;
        private final String queueName;

        MessageDeleteJob(List<DeleteJobData> jobData, String queueName) {
            super(log, null, jobData.iterator());
            this.queueName = queueName;
        }

        private List<String> getMessageIdFromList(String queueName) {
            long offset = 0L;
            LinkedList<String> ids = new LinkedList<String>();
            while (true) {
                List<RqueueMessage> rqueueMessageList;
                if (!CollectionUtils.isEmpty(rqueueMessageList = MessageSweeper.this.messageTemplate.readFromList(queueName, offset, 1000L))) {
                    for (RqueueMessage rqueueMessage : rqueueMessageList) {
                        ids.add(rqueueMessage.getId());
                    }
                }
                if (CollectionUtils.isEmpty(rqueueMessageList) || rqueueMessageList.size() < 1000) break;
                offset += 1000L;
            }
            return ids;
        }

        private List<String> getMessageIdFromZset(String zsetName) {
            LinkedList<String> ids = new LinkedList<String>();
            List<RqueueMessage> rqueueMessageList = MessageSweeper.this.messageTemplate.readFromZset(zsetName, 0L, -1L);
            if (!CollectionUtils.isEmpty(rqueueMessageList)) {
                for (RqueueMessage rqueueMessage : rqueueMessageList) {
                    ids.add(rqueueMessage.getId());
                }
            }
            return ids;
        }

        private List<String> getMessageIds(DeleteJobData data) {
            if (data.type == DataType.LIST) {
                return this.getMessageIdFromList(data.name);
            }
            return this.getMessageIdFromZset(data.name);
        }

        public void delete(DeleteJobData data) {
            for (List subIds : ListUtils.partition(this.getMessageIds(data), (int)1000)) {
                List<String> messageMetaIds = subIds.stream().map(e -> RqueueMessageUtils.getMessageMetaId(this.queueName, e)).collect(Collectors.toList());
                MessageSweeper.this.rqueueMessageMetadataService.deleteAll(messageMetaIds);
                log.debug("Deleted {} messages meta", (Object)messageMetaIds.size());
            }
            MessageSweeper.this.messageTemplate.deleteCollection(data.name);
        }

        @Override
        public void consume(DeleteJobData data) {
            this.delete(data);
        }
    }
}

