/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.dao.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.core.RedisScriptFactory;
import com.github.sonus21.rqueue.dao.RqueueStringDao;
import com.github.sonus21.rqueue.utils.RedisUtils;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.CollectionUtils;

public class RqueueStringDaoImpl
implements RqueueStringDao {
    private final RqueueRedisTemplate<String> redisTemplate;
    private final RedisScript<Boolean> delIfSameScript;
    private final DefaultScriptExecutor<String> scriptExecutor;

    public RqueueStringDaoImpl(RqueueConfig rqueueConfig) {
        this.redisTemplate = new RqueueRedisTemplate(rqueueConfig.getConnectionFactory());
        this.delIfSameScript = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.DELETE_IF_SAME);
        this.scriptExecutor = new DefaultScriptExecutor(this.redisTemplate.getRedisTemplate());
    }

    @Override
    public Map<String, List<Object>> readFromLists(List<String> keys) {
        HashMap<String, List<Object>> out = new HashMap<String, List<Object>>();
        List<Object> redisOut = RedisUtils.executePipeLine(this.redisTemplate.getRedisTemplate(), (connection, keySerializer, valueSerializer) -> {
            for (String key : keys) {
                connection.lRange(Objects.requireNonNull(keySerializer.serialize((Object)key)), 0L, -1L);
            }
        });
        for (int i = 0; i < keys.size(); ++i) {
            List values = (List)redisOut.get(i);
            if (CollectionUtils.isEmpty((Collection)values)) continue;
            out.put(keys.get(i), values);
        }
        return out;
    }

    @Override
    public List<Object> readFromList(String key) {
        return this.readFromLists(Collections.singletonList(key)).getOrDefault(key, Collections.emptyList());
    }

    @Override
    public void appendToListWithListExpiry(String listName, String data, Duration duration) {
        RedisUtils.executePipeLine(this.redisTemplate.getRedisTemplate(), (connection, keySerializer, valueSerializer) -> {
            byte[] key = keySerializer.serialize((Object)listName);
            byte[] value = valueSerializer.serialize((Object)data);
            connection.rPush(key, (byte[][])new byte[][]{value});
            connection.expire(key, duration.getSeconds());
        });
    }

    @Override
    public void appendToSet(String setName, String ... data) {
        this.redisTemplate.addToSet(setName, (Serializable[])data);
    }

    @Override
    public List<String> readFromSet(String setName) {
        Set<String> data = this.redisTemplate.getMembers(setName);
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(data);
    }

    @Override
    public Boolean delete(String key) {
        return this.redisTemplate.delete(key);
    }

    @Override
    public void set(String key, Object data) {
        this.redisTemplate.set(key, (String)data);
    }

    @Override
    public Object get(String key) {
        return this.redisTemplate.get(key);
    }

    @Override
    public Object delete(Collection<String> keys) {
        return this.deleteAndSet(keys, null);
    }

    @Override
    public Object deleteAndSet(Collection<String> keysToBeRemoved, Map<String, Object> objectsToBeStored) {
        return RedisUtils.executePipeLine(this.redisTemplate.getRedisTemplate(), (connection, keySerializer, valueSerializer) -> {
            for (String string : keysToBeRemoved) {
                connection.del((byte[][])new byte[][]{keySerializer.serialize((Object)string)});
            }
            if (!CollectionUtils.isEmpty((Map)objectsToBeStored)) {
                for (Map.Entry entry : objectsToBeStored.entrySet()) {
                    connection.set(Objects.requireNonNull(keySerializer.serialize((Object)((String)entry.getKey()))), Objects.requireNonNull(valueSerializer.serialize(entry.getValue())));
                }
            }
        });
    }

    @Override
    public Boolean setIfAbsent(String key, String value, Duration duration) {
        return this.redisTemplate.setIfAbsent(key, value, duration);
    }

    @Override
    public Long getListSize(String name) {
        return this.redisTemplate.getListSize(name);
    }

    @Override
    public Long getSortedSetSize(String name) {
        return this.redisTemplate.getZsetSize(name);
    }

    @Override
    public DataType type(String key) {
        return this.redisTemplate.type(key);
    }

    @Override
    public Boolean deleteIfSame(String key, String value) {
        return (Boolean)this.scriptExecutor.execute(this.delIfSameScript, Collections.singletonList(key), new Object[]{value});
    }

    @Override
    public void addToOrderedSetWithScore(String key, String value, long score) {
        this.redisTemplate.zadd(key, value, score);
    }

    @Override
    public List<ZSetOperations.TypedTuple<String>> readFromOrderedSetWithScoreBetween(String key, long start, long end) {
        Set<ZSetOperations.TypedTuple<String>> messages = this.redisTemplate.zrangeWithScore(key, start, end);
        if (CollectionUtils.isEmpty(messages)) {
            return Collections.emptyList();
        }
        return new ArrayList<ZSetOperations.TypedTuple<String>>(messages);
    }

    @Override
    public void deleteAll(String key, long min, long max) {
        this.redisTemplate.zremRangeByScore(key, min, max);
    }
}

