/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.annotation.MessageListener;
import com.github.sonus21.rqueue.annotation.RqueueHandler;
import com.github.sonus21.rqueue.annotation.RqueueListener;
import com.github.sonus21.rqueue.core.DefaultRqueueMessageConverter;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.support.RqueueMessageUtils;
import com.github.sonus21.rqueue.exception.QueueDoesNotExist;
import com.github.sonus21.rqueue.listener.MappingInformation;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.Concurrency;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.RetryableRunnable;
import com.github.sonus21.rqueue.utils.ThreadUtils;
import com.github.sonus21.rqueue.utils.ValueResolver;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.annotation.support.AnnotationExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.invocation.AbstractMethodMessageHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.comparator.ComparableComparator;

public class RqueueMessageHandler
extends AbstractMethodMessageHandler<MappingInformation> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageHandler.class);
    private final ConversionService conversionService;
    private final MessageConverter messageConverter;
    private final boolean inspectAllBean;
    private final AsyncTaskExecutor asyncTaskExecutor;
    private final Map<String, MappingInformation> destinationLookup = new HashMap<String, MappingInformation>(64);
    private final MultiValueMap<MappingInformation, HandlerMethodWithPrimary> handlerMethods = new LinkedMultiValueMap(64);

    public RqueueMessageHandler(MessageConverter messageConverter, boolean inspectAllBean) {
        Assert.notNull((Object)messageConverter, (String)"messageConverter cannot be null");
        this.messageConverter = messageConverter;
        this.inspectAllBean = inspectAllBean;
        this.conversionService = new DefaultFormattingConversionService();
        this.asyncTaskExecutor = ThreadUtils.createTaskExecutor("rqueueMessageExecutor", "multiMessageExecutor-", -1, -1, 0);
    }

    @VisibleForTesting
    public RqueueMessageHandler() {
        this((MessageConverter)new DefaultRqueueMessageConverter());
    }

    public RqueueMessageHandler(MessageConverter messageConverter) {
        this(messageConverter, true);
    }

    private ConfigurableBeanFactory getBeanFactory() {
        ApplicationContext context = this.getApplicationContext();
        return context instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)context).getBeanFactory() : null;
    }

    protected List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        ArrayList<Object> resolvers = new ArrayList<Object>(this.getCustomArgumentResolvers());
        resolvers.add(new HeaderMethodArgumentResolver(this.conversionService, this.getBeanFactory()));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new PrincipalMethodArgumentResolver());
        resolvers.add(new MessageMethodArgumentResolver(this.messageConverter));
        resolvers.add(new PayloadMethodArgumentResolver(this.messageConverter));
        return resolvers;
    }

    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        return new ArrayList(this.getCustomReturnValueHandlers());
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        for (Map.Entry<String, MappingInformation> e : this.destinationLookup.entrySet()) {
            List handlerMethodWithPrimaries = (List)this.handlerMethods.get((Object)e.getValue());
            if (handlerMethodWithPrimaries.size() <= 1 || handlerMethodWithPrimaries.stream().filter(m -> m.primary).count() == 1L) continue;
            this.logger.error((Object)("There must be exactly one primary listener method, queue: '" + e.getKey() + "'"));
            throw new IllegalStateException("There must be exactly one primary listener method");
        }
    }

    private boolean isMessageHandler(Class<?> beanType) {
        RqueueListener rqueueListener = (RqueueListener)AnnotationUtils.findAnnotation(beanType, RqueueListener.class);
        if (rqueueListener != null) {
            MappingInformation information = this.getMappingInformation(rqueueListener);
            Map methods = MethodIntrospector.selectMethods(beanType, method -> this.getMappingInformation(method, information));
            Object handler = Objects.requireNonNull(this.getBeanFactory()).getBean(beanType);
            methods.forEach((key, value) -> this.registerHandlerMethod(handler, (Method)key, (MappingInformation)value));
        }
        return rqueueListener != null;
    }

    protected boolean isHandler(Class<?> beanType) {
        if (this.isMessageHandler(beanType)) {
            return false;
        }
        if (this.inspectAllBean) {
            return true;
        }
        return AnnotatedElementUtils.hasAnnotation(beanType, MessageListener.class);
    }

    public MultiValueMap<MappingInformation, HandlerMethodWithPrimary> getHandlerMethodMap() {
        return this.handlerMethods;
    }

    private void addMatchesToCollection(MappingInformation mapping, Message<?> message, Set<Match> matches) {
        MappingInformation match = this.getMatchingMapping(mapping, message);
        if (match != null) {
            for (HandlerMethodWithPrimary method : (List)this.getHandlerMethodMap().get((Object)mapping)) {
                matches.add(new Match(match, method));
            }
        }
    }

    protected void registerHandlerMethod(Object handler, Method method, MappingInformation mapping) {
        for (String pattern : this.getDirectLookupDestinations(mapping)) {
            MappingInformation oldMapping = this.destinationLookup.get(pattern);
            if (oldMapping != null && !oldMapping.equals(mapping)) {
                List methods = (List)this.handlerMethods.get((Object)oldMapping);
                throw new IllegalStateException("More than one listeners are registered to same queue\nExisting Methods " + methods + "\nNew Method: [" + method + "]");
            }
            this.destinationLookup.put(pattern, mapping);
        }
        this.handlerMethods.add((Object)mapping, (Object)new HandlerMethodWithPrimary(this.createHandlerMethod(handler, method), mapping.isPrimary()));
    }

    protected void handleMessageInternal(Message<?> message, String lookupDestination) {
        MappingInformation mapping = this.destinationLookup.get(lookupDestination);
        HashSet<Match> matches = new HashSet<Match>();
        this.addMatchesToCollection(mapping, message, matches);
        if (matches.isEmpty()) {
            this.handleNoMatch(this.getHandlerMethodMap().keySet(), lookupDestination, message);
            return;
        }
        this.executeMatches(matches, message, lookupDestination);
    }

    private void executeMultipleMatch(List<Match> matches, Message<?> message, String lookupDestination) {
        Match primaryMatch = null;
        for (Match match : matches) {
            if (!match.handlerMethod.primary) continue;
            primaryMatch = match;
        }
        if (primaryMatch == null) {
            throw new IllegalStateException("At least one of them must be primary");
        }
        for (Match match : matches) {
            if (match.handlerMethod.primary) continue;
            Message<?> clonedMessage = RqueueMessageUtils.cloneMessage(message);
            this.asyncTaskExecutor.execute((Runnable)new MultiHandler(match, clonedMessage, lookupDestination));
        }
        this.handleMatch(primaryMatch.information, primaryMatch.handlerMethod.method, lookupDestination, message);
    }

    private void executeMatches(Set<Match> matchesIn, Message<?> message, String lookupDestination) {
        ArrayList<Match> matches = new ArrayList<Match>(matchesIn);
        if (matches.size() == 1) {
            Match match = (Match)matches.get(0);
            this.handleMatch(match.information, match.handlerMethod.method, lookupDestination, message);
        } else {
            this.executeMultipleMatch(matches, message, lookupDestination);
        }
    }

    private MappingInformation getMappingInformation(Method method, MappingInformation mappingInformation) {
        RqueueHandler rqueueHandler = (RqueueHandler)AnnotationUtils.findAnnotation((Method)method, RqueueHandler.class);
        if (rqueueHandler == null) {
            return null;
        }
        return mappingInformation.toBuilder().primary(rqueueHandler.primary()).build();
    }

    private MappingInformation getMappingInformation(RqueueListener rqueueListener) {
        Set<String> queueNames = this.resolveQueueNames(rqueueListener);
        String deadLetterQueueName = this.resolveDeadLetterQueue(rqueueListener);
        int numRetries = this.resolveNumRetries(rqueueListener);
        long visibilityTimeout = this.resolveVisibilityTimeout(rqueueListener);
        boolean active = this.isActive(rqueueListener);
        boolean consumerEnabled = this.resolveConsumerEnabled(rqueueListener);
        Concurrency concurrency = this.resolveConcurrency(rqueueListener);
        Map<String, Integer> priorityMap = this.resolvePriority(rqueueListener);
        String priorityGroup = this.resolvePriorityGroup(rqueueListener);
        int batchSize = this.getBatchSize(rqueueListener, concurrency);
        MappingInformation mappingInformation = MappingInformation.builder().active(active).concurrency(concurrency).deadLetterQueueName(deadLetterQueueName).deadLetterConsumerEnabled(consumerEnabled).numRetry(numRetries).queueNames(queueNames).visibilityTimeout(visibilityTimeout).priorityGroup(priorityGroup).priority(priorityMap).batchSize(batchSize).doNotRetry(new HashSet<Class<? extends Throwable>>(Arrays.asList(rqueueListener.doNotRetry()))).build();
        if (mappingInformation.isValid()) {
            return mappingInformation;
        }
        this.logger.warn((Object)("Invalid Queue '" + mappingInformation + "' configuration"));
        return null;
    }

    private int getBatchSize(RqueueListener rqueueListener, Concurrency concurrency) {
        int val = ValueResolver.resolveKeyToInteger(this.getApplicationContext(), rqueueListener.batchSize());
        if (val < 1) {
            val = concurrency.isValid() ? 10 : 1;
        }
        return val;
    }

    protected MappingInformation getMappingForMethod(Method method, Class<?> handlerType) {
        RqueueListener rqueueListener = (RqueueListener)AnnotationUtils.findAnnotation((Method)method, RqueueListener.class);
        if (rqueueListener != null) {
            return this.getMappingInformation(rqueueListener);
        }
        return null;
    }

    private Concurrency resolveConcurrency(RqueueListener rqueueListener) {
        String val = ValueResolver.resolveKeyToString(this.getApplicationContext(), rqueueListener.concurrency());
        if (val.equals("-1")) {
            return new Concurrency(-1, -1);
        }
        String[] vals = val.split("-");
        if (vals.length > 2 || vals.length == 0) {
            throw new IllegalStateException("Concurrency must be either some number e.g. 5 or in the form of 5-10");
        }
        if (vals.length == 1) {
            int concurrency = this.parseInt(vals[0], "Concurrency is not a number", "Concurrency is not a number");
            return new Concurrency(1, concurrency);
        }
        int lowerLimit = this.parseInt(vals[0], "Concurrency lower limit is not a number", "Concurrency lower limit must be non-zero");
        if (lowerLimit < 1) {
            throw new IllegalStateException("lower limit of concurrency must be greater than or equal to 1");
        }
        int upperLimit = this.parseInt(vals[1], "Concurrency upper limit is not a number", "Concurrency upper limit must be non-zero");
        if (lowerLimit > upperLimit) {
            throw new IllegalStateException("upper limit of concurrency is smaller than the lower limit");
        }
        return new Concurrency(lowerLimit, upperLimit);
    }

    private String resolvePriorityGroup(RqueueListener rqueueListener) {
        return ValueResolver.resolveKeyToString(this.getApplicationContext(), rqueueListener.priorityGroup());
    }

    private int parseInt(String txt, String message, String nonZeroText) {
        try {
            int n = Integer.parseInt(txt);
            if (n <= 0) {
                throw new IllegalStateException(nonZeroText);
            }
            return n;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(message, e);
        }
    }

    private Map<String, Integer> resolvePriority(RqueueListener rqueueListener) {
        String[] priorities = ValueResolver.resolveKeyToArrayOfStrings(this.getApplicationContext(), rqueueListener.priority());
        HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        if (priorities.length == 0 || priorities[0].equals("")) {
            return priorityMap;
        }
        for (String priority : priorities) {
            String[] vals = priority.split(":");
            if (vals.length == 1) {
                vals = priority.split("=");
            }
            if (vals.length == 1) {
                if (!priorityMap.isEmpty()) {
                    throw new IllegalStateException("Invalid priority configuration is used.");
                }
                priorityMap.put("DEFAULT_PRIORITY", this.parseInt(vals[0], "priority is not a number.", "priority must be greater than or equal to 1"));
                continue;
            }
            if (vals.length == 2) {
                priorityMap.put(vals[0], this.parseInt(vals[1], "priority is not a number.", "priority must be greater than or equal to 1"));
                continue;
            }
            throw new IllegalStateException("Priority cannot be parsed");
        }
        return Collections.unmodifiableMap(priorityMap);
    }

    private boolean resolveConsumerEnabled(RqueueListener rqueueListener) {
        return ValueResolver.resolveToBoolean(this.getApplicationContext(), rqueueListener.deadLetterQueueListenerEnabled());
    }

    private long resolveVisibilityTimeout(RqueueListener rqueueListener) {
        long value = ValueResolver.resolveKeyToLong(this.getApplicationContext(), rqueueListener.visibilityTimeout());
        if (value < 10L) {
            throw new IllegalStateException("Visibility  must be greater than or equal to 10");
        }
        return value;
    }

    private int resolveNumRetries(RqueueListener rqueueListener) {
        return ValueResolver.resolveKeyToInteger(this.getApplicationContext(), rqueueListener.numRetries());
    }

    private String resolveDeadLetterQueue(RqueueListener rqueueListener) {
        String dlqName = rqueueListener.deadLetterQueue();
        String[] resolvedValues = ValueResolver.resolveKeyToArrayOfStrings(this.getApplicationContext(), dlqName);
        if (resolvedValues.length == 1) {
            return resolvedValues[0];
        }
        throw new IllegalStateException("more than one dead letter queue cannot be configured '" + dlqName + "'");
    }

    private boolean isActive(RqueueListener rqueueListener) {
        return ValueResolver.resolveToBoolean(this.getApplicationContext(), rqueueListener.active());
    }

    private void checkInvalidQueueName(Set<String> queueNames) {
        LinkedList<String> invalidNames = new LinkedList<String>();
        Character[] invalidChars = new Character[]{Character.valueOf('{'), Character.valueOf('}'), Character.valueOf(' '), Character.valueOf('<'), Character.valueOf('>')};
        for (String queue : queueNames) {
            block1: for (int i = 0; i < queue.length(); ++i) {
                Character[] characterArray = invalidChars;
                int n = characterArray.length;
                for (int j = 0; j < n; ++j) {
                    char invalidChar = characterArray[j].charValue();
                    if (queue.charAt(i) != invalidChar) continue;
                    invalidNames.add(queue);
                    continue block1;
                }
            }
        }
        if (!invalidNames.isEmpty()) {
            String invalidCharsStr = Stream.of(invalidChars).map(e -> String.format("'%c'", e)).collect(Collectors.joining(","));
            String queueNamesStr = invalidNames.stream().map(e -> String.format("'%s'", e)).collect(Collectors.joining(","));
            String message = String.format("Queue name contains invalid char%n Not Allowed Chars [%s] %n Queues: [%s]", invalidCharsStr, queueNamesStr);
            throw new IllegalStateException(message);
        }
    }

    private Set<String> resolveQueueNames(RqueueListener rqueueListener) {
        String[] queueNames = rqueueListener.value();
        HashSet<String> result = new HashSet<String>(queueNames.length);
        for (String queueName : queueNames) {
            result.addAll(Arrays.asList(ValueResolver.resolveKeyToArrayOfStrings(this.getApplicationContext(), queueName)));
        }
        this.checkInvalidQueueName(result);
        return Collections.unmodifiableSet(result);
    }

    protected Set<String> getDirectLookupDestinations(MappingInformation mapping) {
        HashSet<String> destinations = new HashSet<String>(mapping.getQueueNames());
        for (String queueName : mapping.getQueueNames()) {
            destinations.addAll(PriorityUtils.getNamesFromPriority(queueName, mapping.getPriority()));
        }
        return destinations;
    }

    protected String getDestination(Message<?> message) {
        return (String)message.getHeaders().get((Object)"destination");
    }

    protected MappingInformation getMatchingMapping(MappingInformation mapping, Message<?> message) {
        String destination = this.getDestination(message);
        if (mapping.getQueueNames().contains(destination)) {
            return mapping;
        }
        try {
            QueueDetail queueDetail = EndpointRegistry.get(destination);
            if (queueDetail.isSystemGenerated()) {
                queueDetail = EndpointRegistry.get(queueDetail.getPriorityGroup());
                if (mapping.getQueueNames().contains(queueDetail.getName())) {
                    return mapping;
                }
            }
        }
        catch (QueueDoesNotExist e) {
            return null;
        }
        return null;
    }

    protected Comparator<MappingInformation> getMappingComparator(Message<?> message) {
        return new ComparableComparator();
    }

    protected AbstractExceptionHandlerMethodResolver createExceptionHandlerMethodResolverFor(Class<?> beanType) {
        return new AnnotationExceptionHandlerMethodResolver(beanType);
    }

    protected void processHandlerMethodException(HandlerMethod handlerMethod, Exception ex, Message<?> message) {
        super.processHandlerMethodException(handlerMethod, ex, message);
        throw new MessagingException("An exception occurred while invoking the handler method", (Throwable)ex);
    }

    @Generated
    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    static class HandlerMethodWithPrimary {
        HandlerMethod method;
        boolean primary;

        public String toString() {
            return this.method.toString();
        }

        @Generated
        public HandlerMethodWithPrimary(HandlerMethod method, boolean primary) {
            this.method = method;
            this.primary = primary;
        }
    }

    private static class Match {
        private final MappingInformation information;
        private final HandlerMethodWithPrimary handlerMethod;

        @Generated
        public Match(MappingInformation information, HandlerMethodWithPrimary handlerMethod) {
            this.information = information;
            this.handlerMethod = handlerMethod;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Match)) {
                return false;
            }
            Match other = (Match)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MappingInformation this$information = this.information;
            MappingInformation other$information = other.information;
            if (this$information == null ? other$information != null : !((Object)this$information).equals(other$information)) {
                return false;
            }
            HandlerMethodWithPrimary this$handlerMethod = this.handlerMethod;
            HandlerMethodWithPrimary other$handlerMethod = other.handlerMethod;
            return !(this$handlerMethod == null ? other$handlerMethod != null : !this$handlerMethod.equals(other$handlerMethod));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Match;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MappingInformation $information = this.information;
            result = result * 59 + ($information == null ? 43 : ((Object)$information).hashCode());
            HandlerMethodWithPrimary $handlerMethod = this.handlerMethod;
            result = result * 59 + ($handlerMethod == null ? 43 : $handlerMethod.hashCode());
            return result;
        }
    }

    private class MultiHandler
    extends RetryableRunnable<Object> {
        private final Match match;
        private final Message<?> message;
        private final String lookupDestination;

        protected MultiHandler(Match match, Message<?> message, String lookupDestination) {
            super(log, "");
            this.match = match;
            this.message = message;
            this.lookupDestination = lookupDestination;
        }

        @Override
        public void start() {
            RqueueMessageHandler.this.handleMatch(this.match.information, this.match.handlerMethod.method, this.lookupDestination, this.message);
        }
    }
}

