/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.sonus21.rqueue.models.MinMax;
import com.github.sonus21.rqueue.models.SerializableBase;
import com.github.sonus21.rqueue.models.db.DeadLetterQueue;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class QueueConfig
extends SerializableBase {
    private static final long serialVersionUID = 2644813429709395582L;
    private String id;
    private String name;
    private String queueName;
    private String completedQueueName;
    private String processingQueueName;
    private String scheduledQueueName;
    private int numRetry;
    private long visibilityTimeout;
    private boolean paused;
    private MinMax<Integer> concurrency;
    @JsonProperty(value="deadLetterQueuesV2")
    private List<DeadLetterQueue> deadLetterQueues;
    private boolean systemGenerated;
    private String priorityGroup;
    private Map<String, Integer> priority;
    private boolean deleted;
    private Long createdOn;
    private Long updatedOn;
    private Long deletedOn;

    public void updateTime() {
        this.updatedOn = System.currentTimeMillis();
    }

    public boolean updateRetryCount(int newRetryCount) {
        if (this.numRetry != newRetryCount) {
            this.numRetry = newRetryCount;
            return true;
        }
        return false;
    }

    public boolean addDeadLetterQueue(DeadLetterQueue deadLetterQueue) {
        if (this.deadLetterQueues == null) {
            this.deadLetterQueues = new LinkedList<DeadLetterQueue>();
        }
        DeadLetterQueue existing = null;
        for (DeadLetterQueue dlq : this.deadLetterQueues) {
            if (!dlq.getName().equals(deadLetterQueue.getName())) continue;
            if (dlq.isConsumerEnabled() == deadLetterQueue.isConsumerEnabled()) {
                return false;
            }
            existing = dlq;
            break;
        }
        if (existing != null) {
            this.deadLetterQueues.remove(existing);
        }
        this.deadLetterQueues.add(deadLetterQueue);
        return true;
    }

    public boolean updateVisibilityTimeout(long newTimeOut) {
        if (this.visibilityTimeout != newTimeOut) {
            this.visibilityTimeout = newTimeOut;
            return true;
        }
        return false;
    }

    public boolean updateConcurrency(MinMax<Integer> concurrency) {
        if (this.concurrency == null || !this.concurrency.equals(concurrency)) {
            this.concurrency = concurrency;
            return true;
        }
        return false;
    }

    public boolean updatePriorityGroup(String priorityGroup) {
        if (this.priorityGroup == null || !this.priorityGroup.equals(priorityGroup)) {
            this.priorityGroup = priorityGroup;
            return true;
        }
        return false;
    }

    public boolean updatePriority(Map<String, Integer> newPriority) {
        Integer val;
        if (CollectionUtils.isEmpty(newPriority) && !CollectionUtils.isEmpty(this.priority)) {
            this.priority = new HashMap<String, Integer>();
            return true;
        }
        if (CollectionUtils.isEmpty(newPriority)) {
            return false;
        }
        boolean updated = false;
        HashMap<String, Integer> updatedPriority = new HashMap<String, Integer>(this.priority);
        for (Map.Entry<String, Integer> entry : newPriority.entrySet()) {
            val = this.priority.get(entry.getKey());
            if (val != null && val.equals(entry.getValue())) continue;
            updated = true;
            updatedPriority.put(entry.getKey(), entry.getValue());
        }
        for (String key : this.priority.keySet()) {
            val = newPriority.get(key);
            if (val != null) continue;
            updated = true;
            updatedPriority.remove(key);
        }
        if (updated) {
            this.priority = updatedPriority;
        }
        return updated;
    }

    @JsonIgnore
    public boolean isDeadLetterQueue(String name) {
        if (!this.hasDeadLetterQueue()) {
            return false;
        }
        for (DeadLetterQueue deadLetterQueue : this.deadLetterQueues) {
            if (!deadLetterQueue.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public boolean hasDeadLetterQueue() {
        return !CollectionUtils.isEmpty(this.deadLetterQueues);
    }

    @Generated
    public static QueueConfigBuilder builder() {
        return new QueueConfigBuilder();
    }

    @Generated
    public QueueConfigBuilder toBuilder() {
        return new QueueConfigBuilder().id(this.id).name(this.name).queueName(this.queueName).completedQueueName(this.completedQueueName).processingQueueName(this.processingQueueName).scheduledQueueName(this.scheduledQueueName).numRetry(this.numRetry).visibilityTimeout(this.visibilityTimeout).paused(this.paused).concurrency(this.concurrency).deadLetterQueues(this.deadLetterQueues).systemGenerated(this.systemGenerated).priorityGroup(this.priorityGroup).priority(this.priority).deleted(this.deleted).createdOn(this.createdOn).updatedOn(this.updatedOn).deletedOn(this.deletedOn);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getCompletedQueueName() {
        return this.completedQueueName;
    }

    @Generated
    public String getProcessingQueueName() {
        return this.processingQueueName;
    }

    @Generated
    public String getScheduledQueueName() {
        return this.scheduledQueueName;
    }

    @Generated
    public int getNumRetry() {
        return this.numRetry;
    }

    @Generated
    public long getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    @Generated
    public boolean isPaused() {
        return this.paused;
    }

    @Generated
    public MinMax<Integer> getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public List<DeadLetterQueue> getDeadLetterQueues() {
        return this.deadLetterQueues;
    }

    @Generated
    public boolean isSystemGenerated() {
        return this.systemGenerated;
    }

    @Generated
    public String getPriorityGroup() {
        return this.priorityGroup;
    }

    @Generated
    public Map<String, Integer> getPriority() {
        return this.priority;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public Long getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public Long getUpdatedOn() {
        return this.updatedOn;
    }

    @Generated
    public Long getDeletedOn() {
        return this.deletedOn;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Generated
    public void setCompletedQueueName(String completedQueueName) {
        this.completedQueueName = completedQueueName;
    }

    @Generated
    public void setProcessingQueueName(String processingQueueName) {
        this.processingQueueName = processingQueueName;
    }

    @Generated
    public void setScheduledQueueName(String scheduledQueueName) {
        this.scheduledQueueName = scheduledQueueName;
    }

    @Generated
    public void setNumRetry(int numRetry) {
        this.numRetry = numRetry;
    }

    @Generated
    public void setVisibilityTimeout(long visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
    }

    @Generated
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Generated
    public void setConcurrency(MinMax<Integer> concurrency) {
        this.concurrency = concurrency;
    }

    @JsonProperty(value="deadLetterQueuesV2")
    @Generated
    public void setDeadLetterQueues(List<DeadLetterQueue> deadLetterQueues) {
        this.deadLetterQueues = deadLetterQueues;
    }

    @Generated
    public void setSystemGenerated(boolean systemGenerated) {
        this.systemGenerated = systemGenerated;
    }

    @Generated
    public void setPriorityGroup(String priorityGroup) {
        this.priorityGroup = priorityGroup;
    }

    @Generated
    public void setPriority(Map<String, Integer> priority) {
        this.priority = priority;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setUpdatedOn(Long updatedOn) {
        this.updatedOn = updatedOn;
    }

    @Generated
    public void setDeletedOn(Long deletedOn) {
        this.deletedOn = deletedOn;
    }

    @Generated
    public String toString() {
        return "QueueConfig(id=" + this.getId() + ", name=" + this.getName() + ", queueName=" + this.getQueueName() + ", completedQueueName=" + this.getCompletedQueueName() + ", processingQueueName=" + this.getProcessingQueueName() + ", scheduledQueueName=" + this.getScheduledQueueName() + ", numRetry=" + this.getNumRetry() + ", visibilityTimeout=" + this.getVisibilityTimeout() + ", paused=" + this.isPaused() + ", concurrency=" + this.getConcurrency() + ", deadLetterQueues=" + this.getDeadLetterQueues() + ", systemGenerated=" + this.isSystemGenerated() + ", priorityGroup=" + this.getPriorityGroup() + ", priority=" + this.getPriority() + ", deleted=" + this.isDeleted() + ", createdOn=" + this.getCreatedOn() + ", updatedOn=" + this.getUpdatedOn() + ", deletedOn=" + this.getDeletedOn() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueConfig)) {
            return false;
        }
        QueueConfig other = (QueueConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumRetry() != other.getNumRetry()) {
            return false;
        }
        if (this.getVisibilityTimeout() != other.getVisibilityTimeout()) {
            return false;
        }
        if (this.isPaused() != other.isPaused()) {
            return false;
        }
        if (this.isSystemGenerated() != other.isSystemGenerated()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$deletedOn = this.getDeletedOn();
        Long other$deletedOn = other.getDeletedOn();
        if (this$deletedOn == null ? other$deletedOn != null : !((Object)this$deletedOn).equals(other$deletedOn)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        String this$completedQueueName = this.getCompletedQueueName();
        String other$completedQueueName = other.getCompletedQueueName();
        if (this$completedQueueName == null ? other$completedQueueName != null : !this$completedQueueName.equals(other$completedQueueName)) {
            return false;
        }
        String this$processingQueueName = this.getProcessingQueueName();
        String other$processingQueueName = other.getProcessingQueueName();
        if (this$processingQueueName == null ? other$processingQueueName != null : !this$processingQueueName.equals(other$processingQueueName)) {
            return false;
        }
        String this$scheduledQueueName = this.getScheduledQueueName();
        String other$scheduledQueueName = other.getScheduledQueueName();
        if (this$scheduledQueueName == null ? other$scheduledQueueName != null : !this$scheduledQueueName.equals(other$scheduledQueueName)) {
            return false;
        }
        MinMax<Integer> this$concurrency = this.getConcurrency();
        MinMax<Integer> other$concurrency = other.getConcurrency();
        if (this$concurrency == null ? other$concurrency != null : !((Object)this$concurrency).equals(other$concurrency)) {
            return false;
        }
        List<DeadLetterQueue> this$deadLetterQueues = this.getDeadLetterQueues();
        List<DeadLetterQueue> other$deadLetterQueues = other.getDeadLetterQueues();
        if (this$deadLetterQueues == null ? other$deadLetterQueues != null : !((Object)this$deadLetterQueues).equals(other$deadLetterQueues)) {
            return false;
        }
        String this$priorityGroup = this.getPriorityGroup();
        String other$priorityGroup = other.getPriorityGroup();
        if (this$priorityGroup == null ? other$priorityGroup != null : !this$priorityGroup.equals(other$priorityGroup)) {
            return false;
        }
        Map<String, Integer> this$priority = this.getPriority();
        Map<String, Integer> other$priority = other.getPriority();
        return !(this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueueConfig;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumRetry();
        long $visibilityTimeout = this.getVisibilityTimeout();
        result = result * 59 + (int)($visibilityTimeout >>> 32 ^ $visibilityTimeout);
        result = result * 59 + (this.isPaused() ? 79 : 97);
        result = result * 59 + (this.isSystemGenerated() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $deletedOn = this.getDeletedOn();
        result = result * 59 + ($deletedOn == null ? 43 : ((Object)$deletedOn).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        String $completedQueueName = this.getCompletedQueueName();
        result = result * 59 + ($completedQueueName == null ? 43 : $completedQueueName.hashCode());
        String $processingQueueName = this.getProcessingQueueName();
        result = result * 59 + ($processingQueueName == null ? 43 : $processingQueueName.hashCode());
        String $scheduledQueueName = this.getScheduledQueueName();
        result = result * 59 + ($scheduledQueueName == null ? 43 : $scheduledQueueName.hashCode());
        MinMax<Integer> $concurrency = this.getConcurrency();
        result = result * 59 + ($concurrency == null ? 43 : ((Object)$concurrency).hashCode());
        List<DeadLetterQueue> $deadLetterQueues = this.getDeadLetterQueues();
        result = result * 59 + ($deadLetterQueues == null ? 43 : ((Object)$deadLetterQueues).hashCode());
        String $priorityGroup = this.getPriorityGroup();
        result = result * 59 + ($priorityGroup == null ? 43 : $priorityGroup.hashCode());
        Map<String, Integer> $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        return result;
    }

    @Generated
    public QueueConfig(String id, String name, String queueName, String completedQueueName, String processingQueueName, String scheduledQueueName, int numRetry, long visibilityTimeout, boolean paused, MinMax<Integer> concurrency, List<DeadLetterQueue> deadLetterQueues, boolean systemGenerated, String priorityGroup, Map<String, Integer> priority, boolean deleted, Long createdOn, Long updatedOn, Long deletedOn) {
        this.id = id;
        this.name = name;
        this.queueName = queueName;
        this.completedQueueName = completedQueueName;
        this.processingQueueName = processingQueueName;
        this.scheduledQueueName = scheduledQueueName;
        this.numRetry = numRetry;
        this.visibilityTimeout = visibilityTimeout;
        this.paused = paused;
        this.concurrency = concurrency;
        this.deadLetterQueues = deadLetterQueues;
        this.systemGenerated = systemGenerated;
        this.priorityGroup = priorityGroup;
        this.priority = priority;
        this.deleted = deleted;
        this.createdOn = createdOn;
        this.updatedOn = updatedOn;
        this.deletedOn = deletedOn;
    }

    @Generated
    public QueueConfig() {
    }

    @Generated
    public static class QueueConfigBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String queueName;
        @Generated
        private String completedQueueName;
        @Generated
        private String processingQueueName;
        @Generated
        private String scheduledQueueName;
        @Generated
        private int numRetry;
        @Generated
        private long visibilityTimeout;
        @Generated
        private boolean paused;
        @Generated
        private MinMax<Integer> concurrency;
        @Generated
        private List<DeadLetterQueue> deadLetterQueues;
        @Generated
        private boolean systemGenerated;
        @Generated
        private String priorityGroup;
        @Generated
        private Map<String, Integer> priority;
        @Generated
        private boolean deleted;
        @Generated
        private Long createdOn;
        @Generated
        private Long updatedOn;
        @Generated
        private Long deletedOn;

        @Generated
        QueueConfigBuilder() {
        }

        @Generated
        public QueueConfigBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public QueueConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public QueueConfigBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        @Generated
        public QueueConfigBuilder completedQueueName(String completedQueueName) {
            this.completedQueueName = completedQueueName;
            return this;
        }

        @Generated
        public QueueConfigBuilder processingQueueName(String processingQueueName) {
            this.processingQueueName = processingQueueName;
            return this;
        }

        @Generated
        public QueueConfigBuilder scheduledQueueName(String scheduledQueueName) {
            this.scheduledQueueName = scheduledQueueName;
            return this;
        }

        @Generated
        public QueueConfigBuilder numRetry(int numRetry) {
            this.numRetry = numRetry;
            return this;
        }

        @Generated
        public QueueConfigBuilder visibilityTimeout(long visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        @Generated
        public QueueConfigBuilder paused(boolean paused) {
            this.paused = paused;
            return this;
        }

        @Generated
        public QueueConfigBuilder concurrency(MinMax<Integer> concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        @JsonProperty(value="deadLetterQueuesV2")
        @Generated
        public QueueConfigBuilder deadLetterQueues(List<DeadLetterQueue> deadLetterQueues) {
            this.deadLetterQueues = deadLetterQueues;
            return this;
        }

        @Generated
        public QueueConfigBuilder systemGenerated(boolean systemGenerated) {
            this.systemGenerated = systemGenerated;
            return this;
        }

        @Generated
        public QueueConfigBuilder priorityGroup(String priorityGroup) {
            this.priorityGroup = priorityGroup;
            return this;
        }

        @Generated
        public QueueConfigBuilder priority(Map<String, Integer> priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public QueueConfigBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Generated
        public QueueConfigBuilder createdOn(Long createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        @Generated
        public QueueConfigBuilder updatedOn(Long updatedOn) {
            this.updatedOn = updatedOn;
            return this;
        }

        @Generated
        public QueueConfigBuilder deletedOn(Long deletedOn) {
            this.deletedOn = deletedOn;
            return this;
        }

        @Generated
        public QueueConfig build() {
            return new QueueConfig(this.id, this.name, this.queueName, this.completedQueueName, this.processingQueueName, this.scheduledQueueName, this.numRetry, this.visibilityTimeout, this.paused, this.concurrency, this.deadLetterQueues, this.systemGenerated, this.priorityGroup, this.priority, this.deleted, this.createdOn, this.updatedOn, this.deletedOn);
        }

        @Generated
        public String toString() {
            return "QueueConfig.QueueConfigBuilder(id=" + this.id + ", name=" + this.name + ", queueName=" + this.queueName + ", completedQueueName=" + this.completedQueueName + ", processingQueueName=" + this.processingQueueName + ", scheduledQueueName=" + this.scheduledQueueName + ", numRetry=" + this.numRetry + ", visibilityTimeout=" + this.visibilityTimeout + ", paused=" + this.paused + ", concurrency=" + this.concurrency + ", deadLetterQueues=" + this.deadLetterQueues + ", systemGenerated=" + this.systemGenerated + ", priorityGroup=" + this.priorityGroup + ", priority=" + this.priority + ", deleted=" + this.deleted + ", createdOn=" + this.createdOn + ", updatedOn=" + this.updatedOn + ", deletedOn=" + this.deletedOn + ")";
        }
    }
}

