/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.listener.QueueDetail;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public final class QueueThreadPool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueueThreadPool.class);
    private final AsyncTaskExecutor taskExecutor;
    private final boolean defaultExecutor;
    private final Semaphore semaphore;
    private final int maxJobsCount;

    public QueueThreadPool(AsyncTaskExecutor taskExecutor, boolean defaultExecutor, int maxJobsCount) {
        this.taskExecutor = taskExecutor;
        this.defaultExecutor = defaultExecutor;
        this.maxJobsCount = maxJobsCount;
        this.semaphore = new Semaphore(maxJobsCount);
    }

    public void release() {
        this.release(1);
    }

    public void release(int n) {
        if (n > 0) {
            this.semaphore.release(n);
        }
    }

    public boolean acquire(int n, long timeout) throws InterruptedException {
        if (log.isDebugEnabled() && this.taskExecutor instanceof ThreadPoolTaskExecutor) {
            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)this.taskExecutor;
            log.debug("Current active threads {}", (Object)executor.getActiveCount());
        }
        return this.semaphore.tryAcquire(n, timeout, TimeUnit.MILLISECONDS);
    }

    public void execute(Runnable r) {
        this.taskExecutor.execute(r);
    }

    public int availableThreads() {
        return this.semaphore.availablePermits();
    }

    public boolean allTasksCompleted() {
        int permits = this.availableThreads();
        if (permits > this.maxJobsCount) {
            log.error("More number of release is called");
        }
        return permits >= this.maxJobsCount;
    }

    public String destroy() {
        if (!this.defaultExecutor) {
            return null;
        }
        if (this.taskExecutor instanceof ThreadPoolTaskExecutor) {
            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)this.taskExecutor;
            executor.destroy();
            return executor.getThreadNamePrefix();
        }
        return null;
    }

    public void taskRejected(QueueDetail queueDetail, RqueueMessage message) {
        log.warn("Task rejected by executor Queue: {}, Message: {}", (Object)queueDetail.getName(), (Object)message.getMessage());
    }
}

