/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.converter.RqueueRedisSerializer;
import java.util.List;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public final class RedisUtils {
    public static RedisTemplateProvider redisTemplateProvider = new RedisTemplateProvider(){

        @Override
        public <V> RedisTemplate<String, V> getRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
            RedisTemplate redisTemplate = new RedisTemplate();
            StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
            RqueueRedisSerializer rqueueRedisSerializer = new RqueueRedisSerializer();
            redisTemplate.setConnectionFactory(redisConnectionFactory);
            redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
            redisTemplate.setValueSerializer((RedisSerializer)rqueueRedisSerializer);
            redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
            redisTemplate.setHashValueSerializer((RedisSerializer)rqueueRedisSerializer);
            return redisTemplate;
        }
    };
    public static RedisSerializationContextProvider redisSerializationContextProvider = () -> {
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        RqueueRedisSerializer rqueueRedisSerializer = new RqueueRedisSerializer();
        RedisSerializationContext.RedisSerializationContextBuilder redisSerializationContextBuilder = RedisSerializationContext.newSerializationContext();
        redisSerializationContextBuilder = redisSerializationContextBuilder.key((RedisSerializer)stringRedisSerializer);
        redisSerializationContextBuilder = redisSerializationContextBuilder.value((RedisSerializer)rqueueRedisSerializer);
        redisSerializationContextBuilder = redisSerializationContextBuilder.hashKey((RedisSerializer)stringRedisSerializer);
        redisSerializationContextBuilder = redisSerializationContextBuilder.hashValue((RedisSerializer)rqueueRedisSerializer);
        return redisSerializationContextBuilder.build();
    };
    public static ReactiveRedisTemplateProvider reactiveRedisTemplateProvider = new ReactiveRedisTemplateProvider(){

        @Override
        public <V> ReactiveRedisTemplate<String, V> getRedisTemplate(ReactiveRedisConnectionFactory redisConnectionFactory) {
            return new ReactiveRedisTemplate(redisConnectionFactory, redisSerializationContextProvider.getSerializationContext());
        }
    };

    private RedisUtils() {
    }

    public static <V> RedisTemplate<String, V> getRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        return redisTemplateProvider.getRedisTemplate(redisConnectionFactory);
    }

    public static <V> ReactiveRedisTemplate<String, V> getReactiveRedisTemplate(ReactiveRedisConnectionFactory redisConnectionFactory) {
        return reactiveRedisTemplateProvider.getRedisTemplate(redisConnectionFactory);
    }

    public static <V> List<Object> executePipeLine(RedisTemplate<String, V> template, RedisPipelineCallback callback) {
        return template.executePipelined(connection -> {
            RedisSerializer keySerializer = template.getKeySerializer();
            RedisSerializer valueSerializer = template.getValueSerializer();
            callback.doInRedis(connection, (RedisSerializer<String>)keySerializer, (RedisSerializer<Object>)valueSerializer);
            return null;
        });
    }

    public static void setVersion(RqueueRedisTemplate<Integer> rqueueRedisTemplate, String versionKey, int version) {
        rqueueRedisTemplate.set(versionKey, version);
    }

    private static int checkDbVersion(Object data) {
        if (data instanceof Integer || data instanceof Long) {
            return ((Number)data).intValue();
        }
        if (data instanceof String) {
            return Integer.parseInt((String)data);
        }
        if (data != null) {
            throw new IllegalStateException("Invalid db version" + data);
        }
        return -1;
    }

    public static int updateAndGetVersion(RqueueRedisTemplate<Integer> rqueueRedisTemplate, String versionKey, int defaultVersion) {
        Integer data = rqueueRedisTemplate.get(versionKey);
        int dbVersion = RedisUtils.checkDbVersion(data);
        if (dbVersion > 0) {
            return dbVersion;
        }
        List<Object> result = RedisUtils.executePipeLine(rqueueRedisTemplate.getRedisTemplate(), (connection, keySerializer, valueSerializer) -> connection.eval("return #redis.pcall('keys', 'rqueue-*')".getBytes(), ReturnType.INTEGER, 0, (byte[][])new byte[0][]));
        Long count = (Long)result.get(0);
        if (count != null && count > 0L) {
            rqueueRedisTemplate.set(versionKey, 1);
            return 1;
        }
        rqueueRedisTemplate.set(versionKey, defaultVersion);
        return defaultVersion;
    }

    public static interface RedisTemplateProvider {
        public <V> RedisTemplate<String, V> getRedisTemplate(RedisConnectionFactory var1);
    }

    public static interface ReactiveRedisTemplateProvider {
        public <V> ReactiveRedisTemplate<String, V> getRedisTemplate(ReactiveRedisConnectionFactory var1);
    }

    public static interface RedisPipelineCallback {
        public void doInRedis(RedisConnection var1, RedisSerializer<String> var2, RedisSerializer<Object> var3);
    }

    public static interface RedisSerializationContextProvider {
        public RedisSerializationContext<String, Object> getSerializationContext();
    }
}

